package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueueSet;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsModule;

/**
 * Creates {@link WlsJmsQueueSet JMS queue set}.
 */
@SuppressWarnings("serial")
public class CreateWlsJmsQueueSetStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-jms-queueset.py";

	public CreateWlsJmsQueueSetStep(Host domainHost, WlsDomain domain, WlsJmsModule targetModule, WlsJmsQueueSet queue, 
			Set<WlsServer> servers) {
		super("Create JMS QueueSet " + queue + " in domain " + domain + " in module " + targetModule, domain, SCRIPT_RESOURCE_PATH,
				getArgs(targetModule, queue, servers));
	}

	private static String[] getArgs(WlsJmsModule targetModule, WlsJmsQueueSet queue, Set<WlsServer> servers) {
		List<String> args = new ArrayList<String>();
		String targetModuleName = targetModule.getName(); 
		args.add(targetModuleName);
		args.add(queue.getName());
		args.add(queue.getJndiName());
		args.add(String.valueOf(queue.getRedeliveryLimits()));
		
		String jmsServerPrefix = createJMServerPrefix(targetModuleName);
		List<WlsServer> sortedServers = WlsServer.toNameSortedList(servers);
		for (int i = 0; i < sortedServers.size(); i++) {
			int jmsServerIndex = i + 1;
			String jmsServerName = jmsServerPrefix + "-JMSServer_" + jmsServerIndex;
			
			// unused argument?
			WlsServer server = sortedServers.get(i);
			args.add(server.getName());
			args.add(jmsServerName);
			args.add(jmsServerName + "-subdeployment");

		}
		return args.toArray(new String[args.size()]);
	}

	@SuppressWarnings("unchecked")
	protected static List<WlsServer> sortWebLogicServersOnName(Set<WlsServer> servers) {
		List<WlsServer> sortedServers = new ArrayList<WlsServer>(servers);
		Collections.sort(sortedServers, new BeanComparator("name"));
		return sortedServers;
	}

	protected static String createJMServerPrefix(String moduleName) {
		return StringUtils.remove(moduleName, "-JMSModule");
	}

}