package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsWorkManager;

/**
 * Deletes a {@link WlsWorkManager work manager}.
 */
@SuppressWarnings("serial")
public class DestroyWlsWorkManagerStep extends SimpleWlstExecutingStep {

	public DestroyWlsWorkManagerStep(WlsWorkManager workManager, WlsDomain domain) {
		super("Destroy Work Manager " + workManager, domain, STEP_RESOURCES_PATH + "destroy-work-manager.py", getArgs(workManager,
				domain));
	}

	private static String[] getArgs(WlsWorkManager workManager, WlsDomain domain) {
		List<String> args = new ArrayList<String>();
		args.add(domain.getName());
		args.add(workManager.getName());
		return args.toArray(new String[args.size()]);
	}

}
