package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Starts a deployed {@link NamedDeployableArtifact application}.
 */
@SuppressWarnings("serial")
public class StartApplicationStep extends SimpleWlstExecutingStep {

	private static final String START_APPLICATION_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "start-application.py";

	public StartApplicationStep(WlsCluster cluster, NamedDeployableArtifact artifact) {
		super("Start application " + artifact + " on cluster " + cluster, cluster.getDomain(), START_APPLICATION_SCRIPT_RESOURCE_PATH, artifact.getName());
	}

	public StartApplicationStep(WlsServer server, NamedDeployableArtifact artifact) {
		super("Start application " + artifact + " on server " + server, server.getDomain(), START_APPLICATION_SCRIPT_RESOURCE_PATH, artifact.getName());
	}

}
