package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Stops a deployed {@link NamedDeployableArtifact application}.
 */
@SuppressWarnings("serial")
public class StopApplicationStep extends SimpleWlstExecutingStep {

	private static final String STOP_APPLICATION_SCRIPT_RESOURCES_PATH = STEP_RESOURCES_PATH + "stop-application.py";

	public StopApplicationStep(WlsCluster cluster, NamedDeployableArtifact artifact) {
		super("Stop application " + artifact + " on cluster " + cluster, cluster.getDomain(), STOP_APPLICATION_SCRIPT_RESOURCES_PATH, artifact.getName());
	}

	public StopApplicationStep(WlsServer server, NamedDeployableArtifact artifact) {
		super("Stop application " + artifact + " on server " + server, server.getDomain(), STOP_APPLICATION_SCRIPT_RESOURCES_PATH, artifact.getName());
	}

}
