package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;

/**
 * Checks that there are no pending changes in a {@link WlsDomain domain}; fails if pending changes are found. If there is no open &quot;edit session&quot; this
 * step has no effect.
 */
@SuppressWarnings("serial")
public class WlsActivationStateVerificationStep extends SimpleWlstExecutingStep {

	public static final String ACTIVATION_STATE_VERIFICATION_SCRIPT_NAME = STEP_RESOURCES_PATH + "check-activation-state.py";

	public WlsActivationStateVerificationStep(WlsDomain domain) {
		super("Verifying that there are no pending changes in WebLogic domain " + domain, domain, ACTIVATION_STATE_VERIFICATION_SCRIPT_NAME);
	}

}
