package com.xebialabs.deployit.plugin.wls.step;

import org.springframework.core.io.ClassPathResource;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;

@SuppressWarnings("serial")
public abstract class WlsStepBase implements Step {

	public static final String STEP_RESOURCES_PATH = "com/xebialabs/deployit/plugin/wls/step/";

	protected String description;

	protected WlsDomain domain;

	protected WlsStepBase(WlsDomain domain) {
		this.domain = domain;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public int executeWlstJythonScriptResource(StepExecutionContext ctx, HostSession s, String scriptResourcePath, String... args) {
		String scriptPath = s.copyToTemporaryFile(new ClassPathResource(scriptResourcePath)).getPath();
		CommandExecutionCallbackHandler handler = new StepExecutionContextCallbackHandler(ctx);
		return domain.executeWlstJythonScript(handler, s, scriptPath, args);
	}

	public int executeWlstJythonScriptResource(StepExecutionContext ctx, String scriptResourcePath, String... args) {
		HostSession s = domain.connectToAdminHost();
		try {
			return executeWlstJythonScriptResource(ctx, s, scriptResourcePath, args);
		} finally {
			s.close();
		}
	}

}
