/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.mapper.artifact.ConfigurationFilesToHostMapper;
import com.xebialabs.deployit.mapper.artifact.LibrariesToHostMapper;
import com.xebialabs.deployit.plugin.apache.httpd.mapper.StaticContentToApacheHttpdServerMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.mapper.ApacheHttpdWlsPluginConfigurationToApacheHttpdServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.EarToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.EarToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.EjbToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.EjbToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WarToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WarToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsDataSourceToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsForeignDestinationToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsForeignJmsConnectionFactoryToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsForeignServerToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsJmsConnectionFactoryToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsJmsModuleToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsJmsQueueToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsMaximumThreadsConstraintToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsQueueSetToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WlsWorkManagerToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.runbook.WlsServerRunBook;
import com.xebialabs.deployit.plugin.wls.runbook.WlsSingleTypeHandlingRunBook;
import com.xebialabs.deployit.plugin.wls.step.ActivatePendingChangesStep;
import com.xebialabs.deployit.plugin.wls.step.RestartServersThatRequireRestartStep;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WlsDeploymentRunBook
extends WlsSingleTypeHandlingRunBook<Deployment>
implements RunBook {
    public WlsDeploymentRunBook() {
        super(Deployment.class);
    }

    @Override
    protected void resolve(ChangePlan changePlan, Change<Deployment> change, List<Step> steps) {
        EarToWlsClusterMapper earToClusterMapper = new EarToWlsClusterMapper(change);
        EarToWlsServerMapper earToServerMapper = new EarToWlsServerMapper(change);
        EjbToWlsClusterMapper ejbToClusterMapper = new EjbToWlsClusterMapper(change);
        EjbToWlsServerMapper ejbToServerMapper = new EjbToWlsServerMapper(change);
        WarToWlsClusterMapper warToClusterMapper = new WarToWlsClusterMapper(change);
        WarToWlsServerMapper warToServerMapper = new WarToWlsServerMapper(change);
        WlsDataSourceToWlsClusterMapper dataSourceMapper = new WlsDataSourceToWlsClusterMapper(change);
        WlsJmsModuleToWlsClusterMapper jmsModuleMapper = new WlsJmsModuleToWlsClusterMapper(change);
        WlsQueueSetToWlsClusterMapper queueSetMapper = new WlsQueueSetToWlsClusterMapper(change);
        WlsJmsQueueToWlsServerMapper queueMapper = new WlsJmsQueueToWlsServerMapper(change);
        this.sortQueueMappings(queueMapper);
        WlsJmsConnectionFactoryToWlsClusterMapper jmsConnectionFactoryMapper = new WlsJmsConnectionFactoryToWlsClusterMapper(change);
        WlsForeignServerToWlsClusterMapper foreignServerMapper = new WlsForeignServerToWlsClusterMapper(change);
        WlsForeignDestinationToWlsClusterMapper foreignDestinationMapper = new WlsForeignDestinationToWlsClusterMapper(change);
        WlsForeignJmsConnectionFactoryToWlsClusterMapper foreignJmsConnectionFactoryMapper = new WlsForeignJmsConnectionFactoryToWlsClusterMapper(change);
        WlsMaximumThreadsConstraintToWlsClusterMapper maxThreadsConstraintsMapper = new WlsMaximumThreadsConstraintToWlsClusterMapper(change);
        WlsWorkManagerToWlsClusterMapper workManagerMapper = new WlsWorkManagerToWlsClusterMapper(change);
        ApacheHttpdWlsPluginConfigurationToApacheHttpdServerMapper pluginConfigMapper = new ApacheHttpdWlsPluginConfigurationToApacheHttpdServerMapper(change);
        StaticContentToApacheHttpdServerMapper staticContentMapper = new StaticContentToApacheHttpdServerMapper(change);
        LibrariesToHostMapper librariesMapper = new LibrariesToHostMapper(change);
        ConfigurationFilesToHostMapper configurationFilesToHostMapper = new ConfigurationFilesToHostMapper(change);
        HashSet targetClusters = new HashSet();
        targetClusters.addAll(dataSourceMapper.getAllTargets());
        targetClusters.addAll(jmsModuleMapper.getAllTargets());
        targetClusters.addAll(queueSetMapper.getAllTargets());
        targetClusters.addAll(jmsConnectionFactoryMapper.getAllTargets());
        targetClusters.addAll(foreignServerMapper.getAllTargets());
        targetClusters.addAll(foreignDestinationMapper.getAllTargets());
        targetClusters.addAll(foreignJmsConnectionFactoryMapper.getAllTargets());
        targetClusters.addAll(maxThreadsConstraintsMapper.getAllTargets());
        targetClusters.addAll(workManagerMapper.getAllTargets());
        targetClusters.addAll(earToClusterMapper.getAllTargets());
        targetClusters.addAll(warToClusterMapper.getAllTargets());
        targetClusters.addAll(ejbToClusterMapper.getAllTargets());
        HashSet targetServers = new HashSet();
        targetServers.addAll(queueMapper.getAllTargets());
        targetServers.addAll(earToServerMapper.getAllTargets());
        targetServers.addAll(warToServerMapper.getAllTargets());
        targetServers.addAll(ejbToServerMapper.getAllTargets());
        HashSet targetHosts = new HashSet();
        targetHosts.addAll(configurationFilesToHostMapper.getAllTargets());
        targetHosts.addAll(librariesMapper.getAllTargets());
        if (targetClusters.isEmpty() && targetServers.isEmpty() && targetHosts.isEmpty()) {
            return;
        }
        HashSet<WlsDomain> targetDomains = new HashSet<WlsDomain>();
        for (WlsCluster eachCluster : targetClusters) {
            targetDomains.add(eachCluster.getDomain());
        }
        for (WlsServer eachServer : targetServers) {
            targetDomains.add(eachServer.getDomain());
        }
        int lastStepCount = steps.size();
        earToClusterMapper.generateUndeploySteps(steps);
        earToServerMapper.generateUndeploySteps(steps);
        warToClusterMapper.generateUndeploySteps(steps);
        warToServerMapper.generateUndeploySteps(steps);
        ejbToClusterMapper.generateUndeploySteps(steps);
        ejbToServerMapper.generateUndeploySteps(steps);
        if (steps.size() > lastStepCount) {
            this.activateChanges(steps, targetDomains);
        }
        lastStepCount = steps.size();
        jmsModuleMapper.generateDeletionSteps(steps);
        queueSetMapper.generateDeletionSteps(steps);
        queueMapper.generateDeletionSteps(steps);
        jmsConnectionFactoryMapper.generateDeletionSteps(steps);
        foreignServerMapper.generateDeletionSteps(steps);
        foreignDestinationMapper.generateDeletionSteps(steps);
        foreignJmsConnectionFactoryMapper.generateDeletionSteps(steps);
        dataSourceMapper.generateDeletionSteps(steps);
        workManagerMapper.generateDeletionSteps(steps);
        maxThreadsConstraintsMapper.generateDeletionSteps(steps);
        if (steps.size() > lastStepCount) {
            this.activateChanges(steps, targetDomains);
        }
        configurationFilesToHostMapper.generateDeletionSteps(steps);
        configurationFilesToHostMapper.generateAdditionSteps(steps);
        librariesMapper.generateDeletionSteps(steps);
        librariesMapper.generateAdditionSteps(steps);
        if (change.isModification()) {
            HashSet<WlsServer> oldTargetServers = new HashSet<WlsServer>();
            oldTargetServers.addAll(earToServerMapper.getOldTargets());
            oldTargetServers.addAll(warToServerMapper.getOldTargets());
            oldTargetServers.addAll(ejbToServerMapper.getOldTargets());
            HashSet oldTargetClusters = new HashSet();
            oldTargetClusters.addAll(earToClusterMapper.getOldTargets());
            oldTargetClusters.addAll(warToClusterMapper.getOldTargets());
            oldTargetClusters.addAll(ejbToClusterMapper.getOldTargets());
            for (WlsCluster cluster : oldTargetClusters) {
                oldTargetServers.addAll(cluster.getServers());
            }
            HashSet<WlsServer> newTargetServers = new HashSet<WlsServer>();
            newTargetServers.addAll(earToServerMapper.getNewTargets());
            newTargetServers.addAll(warToServerMapper.getNewTargets());
            newTargetServers.addAll(ejbToServerMapper.getNewTargets());
            HashSet newTargetClusters = new HashSet();
            newTargetClusters.addAll(earToClusterMapper.getNewTargets());
            newTargetClusters.addAll(warToClusterMapper.getNewTargets());
            newTargetClusters.addAll(ejbToClusterMapper.getNewTargets());
            for (WlsCluster cluster : newTargetClusters) {
                newTargetServers.addAll(cluster.getServers());
            }
            Set<Change<WlsServer>> serverChangesForDeploymentChange = this.findServerChangesForDeploymentChange(changePlan, change, oldTargetServers, newTargetServers);
            if (serverChangesForDeploymentChange != null) {
                WlsServerRunBook wlsServerRunBook = new WlsServerRunBook();
                for (Change<WlsServer> eachServerChange : serverChangesForDeploymentChange) {
                    steps.addAll(wlsServerRunBook.getModificationSteps(eachServerChange));
                }
            }
        }
        lastStepCount = steps.size();
        queueMapper.generateModificationSteps(steps);
        if (steps.size() > lastStepCount) {
            this.activateChanges(steps, targetDomains);
        }
        lastStepCount = steps.size();
        jmsModuleMapper.generateAdditionSteps(steps);
        queueSetMapper.generateAdditionSteps(steps);
        queueMapper.generateAdditionSteps(steps);
        jmsConnectionFactoryMapper.generateAdditionSteps(steps);
        foreignServerMapper.generateAdditionSteps(steps);
        foreignDestinationMapper.generateAdditionSteps(steps);
        foreignJmsConnectionFactoryMapper.generateAdditionSteps(steps);
        dataSourceMapper.generateAdditionSteps(steps);
        maxThreadsConstraintsMapper.generateAdditionSteps(steps);
        workManagerMapper.generateAdditionSteps(steps);
        if (steps.size() > lastStepCount) {
            this.activateChanges(steps, targetDomains);
        }
        lastStepCount = steps.size();
        earToClusterMapper.generateDeploySteps(steps);
        earToServerMapper.generateDeploySteps(steps);
        warToClusterMapper.generateDeploySteps(steps);
        warToServerMapper.generateDeploySteps(steps);
        ejbToClusterMapper.generateDeploySteps(steps);
        ejbToServerMapper.generateDeploySteps(steps);
        if (steps.size() > lastStepCount) {
            this.activateChanges(steps, targetDomains);
        }
        earToClusterMapper.generateStartSteps(steps);
        earToServerMapper.generateStartSteps(steps);
        warToClusterMapper.generateStartSteps(steps);
        warToServerMapper.generateStartSteps(steps);
        ejbToClusterMapper.generateStartSteps(steps);
        ejbToServerMapper.generateStartSteps(steps);
        this.restartServersRequiringRestart(steps, targetDomains);
        staticContentMapper.generateDeletionSteps(steps);
        staticContentMapper.generateAdditionSteps(steps);
        pluginConfigMapper.generateDeletionSteps(steps);
        pluginConfigMapper.generateAdditionSteps(steps);
    }

    private void sortQueueMappings(WlsJmsQueueToWlsServerMapper queueMapper) {
        Collections.sort(queueMapper.getAddedMappings(), new WlqJmsQueueSorter(true));
        Collections.sort(queueMapper.getDeletedMappings(), new WlqJmsQueueSorter(false));
    }

    private void activateChanges(List<Step> steps, Set<WlsDomain> domains) {
        for (WlsDomain eachDomain : domains) {
            steps.add(new ActivatePendingChangesStep(eachDomain));
        }
    }

    private void restartServersRequiringRestart(List<Step> steps, Set<WlsDomain> domains) {
        for (WlsDomain eachDomain : domains) {
            steps.add(new RestartServersThatRequireRestartStep(eachDomain));
        }
    }

    private Set<Change<WlsServer>> findServerChangesForDeploymentChange(ChangePlan changePlan, Change<Deployment> deploymentChange, Set<WlsServer> oldTargetServers, Set<WlsServer> newTargetServers) {
        HashSet<Change<WlsServer>> serverChanges = new HashSet<Change<WlsServer>>();
        for (Change serverChange : this.getChangesForCiType(changePlan, WlsServer.class)) {
            if (!serverChange.isModification() || !oldTargetServers.contains(serverChange.getOldRevision()) || !newTargetServers.contains(serverChange.getNewRevision())) continue;
            serverChanges.add((Change<WlsServer>)serverChange);
        }
        return serverChanges;
    }

    private Set<Change> getChangesForCiType(ChangePlan cp, Class<? extends Serializable> changeTypeClass) {
        HashSet<Change> changesOfType = new HashSet<Change>();
        for (Change change : cp.getChanges()) {
            if (!changeTypeClass.equals(change.getConfigurationItemClass())) continue;
            changesOfType.add(change);
        }
        return changesOfType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WlqJmsQueueSorter
    implements Comparator<Mapping> {
        private boolean errorQueuesFirst;

        public WlqJmsQueueSorter(boolean errorQueuesFirst) {
            this.errorQueuesFirst = errorQueuesFirst;
        }

        @Override
        public int compare(Mapping o1, Mapping o2) {
            WlsJmsQueue lhs = (WlsJmsQueue)((Object)o1.getSource());
            WlsJmsQueue rhs = (WlsJmsQueue)((Object)o2.getSource());
            int res = lhs.getErrorQueue() == null ? (rhs.getErrorQueue() == null ? 0 : 1) : (rhs.getErrorQueue() == null ? -1 : 0);
            if (res == 0) {
                res = lhs.getName().compareTo(rhs.getName());
            }
            if (this.errorQueuesFirst) {
                res = -res;
            }
            return res;
        }
    }
}

