import sys
import os
import time as ptime

sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

name = sys.argv.pop(0)
domain = sys.argv.pop(0)
# Could be a comma separated list of servers or clusters
targetName = sys.argv.pop(0)
maximumThreadConstraintName = sys.argv.pop(0)

#=========================#
# Create WorkManager      #
#=========================#
def createWorkManager(name, domain, targetName, maximumThreadConstraintName):
  log("Creating work manager : " + name + " on domain " + domain)
  targetArray = getClusterServerTargetArray(targetName)
  cd('/SelfTuning/' + domain + '/WorkManagers')
  cmo.createWorkManager(name)
  cd('/SelfTuning/' + domain + '/WorkManagers/' + name)
  set('Targets', targetArray)
  if maximumThreadConstraintName != None:
     cmo.setMaxThreadsConstraint(getMBean('/SelfTuning/' + domainName + '/MaxThreadsConstraints/' + maximumThreadConstraintName))
  return
  
#=====================================#
# Get ClustServer Target Array        #
#=====================================#
def getClusterServerTargetArray(targetlist):
    objectArray=[];
    targets=targetlist.split( "," )
    for target in targets:
        bean=getMBean( '/Servers/'+target )
        if bean != None :
            objectArray.append( ObjectName('com.bea:Name=' + bean.getName() + ',Type='+bean.getType()) )
        bean=getMBean( '/Clusters/'+target )
        if bean != None :
            objectArray.append( ObjectName('com.bea:Name=' + bean.getName() + ',Type='+bean.getType()) )
    if objectArray :
        targetArray = jarray.array(objectArray, ObjectName)
    else :
        raise ValueError('Not targets found for '+targetlist )             
    return targetArray

#==============================#
# Logging method               #
#==============================#
def log(msg, level="info"):
    print ptime.strftime("%H:%M:%S", ptime.localtime()) + " <" + level + "> " + msg
    return
    
    
#==============================#
# Entry Point                  #
#==============================#
connect(user, password, url)
edit()
startEdit()
createWorkManager(name, domain, targetName, maximumThreadConstraintName)
save()
disconnect('true')
exit('y')
