/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.WindowsServiceStepExecutionContextCallbackHandler;
import com.xebialabs.deployit.util.TemplateResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WlsWindowsServiceHandler
implements Step {
    protected String serverName;
    protected String domainName;
    protected WlsServer server;
    static final int SERVICE_ALREADY_STARTED = 2182;
    static final int SERVICE_NOT_STARTED = 3521;

    public WlsWindowsServiceHandler(WlsServer server) {
        this.server = server;
        this.serverName = server.getName();
        this.domainName = server.getDomain().getName();
    }

    abstract String getTemplatePath();

    abstract String getCmdPrefix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.server.getHost().getHostSession();
        try {
            HashMap context = Maps.newHashMap();
            context.put("serverName", this.serverName);
            context.put("domainName", this.domainName);
            String evaluatedScript = this.generateWithTemplateResolver(this.getTemplatePath(), context);
            HostFile uploadedDeployScript = rhs.getTempFile(this.getCmdPrefix() + "-" + this.serverName, ".cmd");
            uploadedDeployScript.put(IOUtils.toInputStream((String)evaluatedScript), (long)evaluatedScript.length());
            WindowsServiceStepExecutionContextCallbackHandler stepHandler = new WindowsServiceStepExecutionContextCallbackHandler(ctx);
            int retCode = rhs.execute((CommandExecutionCallbackHandler)stepHandler, new String[]{uploadedDeployScript.getPath().toString()});
            System.out.println("RetCode " + retCode);
            System.out.println(stepHandler.getMessageNumber());
            if (retCode == 0) {
                boolean bl = true;
                return bl;
            }
            switch (stepHandler.getMessageNumber()) {
                case 2182: {
                    boolean bl = true;
                    return bl;
                }
                case 3521: {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            rhs.close();
        }
    }

    protected String generateWithTemplateResolver(String templatePath, Map<String, String> context) {
        InputStream scriptIn;
        try {
            scriptIn = new ClassPathResource(templatePath).getInputStream();
        }
        catch (IOException exc) {
            throw new IllegalArgumentException("Cannot read script template resource " + templatePath, exc);
        }
        try {
            String template = IOUtils.toString((InputStream)scriptIn);
            TemplateResolver r = new TemplateResolver(context);
            String string = r.resolveStrict(template);
            return string;
        }
        catch (IOException exc) {
            throw new RuntimeException("Cannot evaluate script template resource " + templatePath, exc);
        }
        finally {
            IOUtils.closeQuietly((InputStream)scriptIn);
        }
    }
}

