/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A JMS server defined in a {@link WlsDomain WLS domain}.
 * <p>
 * JMS servers should be associated with a {@link WlsServer Managed Server} or Migratable Target in the domain.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "WebLogic JMSServer that can run on a WebLogic Server.")
public class WlsJmsServer extends BaseConfigurationItem implements WlsServerResource {
	@ConfigurationItemProperty(description = "Name of the JMSServer. e.g. JMSServer1", required = true, identifying = true)
	private String name;

	@ConfigurationItemProperty(description = "Path to the file store that the JMSServer will use to store JMS messages. e.g. /var/jms/store1", required = true)
	private String fileStorePath;

	public String getFileStoreName() {
		return name + "-filestore";
	}

	public String getSubdeploymentName(String jmsModuleName) {
		return jmsModuleName + "-subdeployment-to-" + name;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getFileStorePath() {
		return fileStorePath;
	}

	public void setFileStorePath(String fileStorePath) {
		this.fileStorePath = fileStorePath;
	}

}