/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.WlsStepBase;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class WlsDeployNoStageArtifactStep
extends WlsStepBase {
    private static final String DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME = "com/xebialabs/deployit/plugin/wls/step/deploy-nostage-application.py";
    private static final String DEPLOY_APPLICATION_ON_WEBLOGIC_WITH_PLAN_SCRIPT_NAME = "com/xebialabs/deployit/plugin/wls/step/deploy-nostage-plan-application.py";
    private String targetName;
    private String applicationName;
    private String remoteArchivePath;
    private String remoteDeploymentPlanPath;

    public WlsDeployNoStageArtifactStep(WlsTarget wlsTarget, NamedDeployableArtifact artifact, String remoteArchivePath) {
        super(wlsTarget.getDomain());
        this.targetName = wlsTarget.getName();
        this.applicationName = artifact.getName();
        this.remoteArchivePath = remoteArchivePath;
        this.setDescription("Deploy  " + artifact + " on " + (Object)((Object)wlsTarget) + " nostage mode using " + remoteArchivePath);
    }

    public String getDescription() {
        String desc = super.getDescription();
        if (!StringUtils.isBlank((String)this.remoteDeploymentPlanPath)) {
            desc = desc + " and a deployment plan";
        }
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.domain.connectToAdminHost();
        try {
            String[] args;
            int res;
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add(this.domain.getUsername());
            argsList.add(this.domain.getPassword());
            argsList.add(this.domain.getConnectUrl());
            argsList.add(this.targetName);
            argsList.add(this.applicationName);
            argsList.add(rhs.getFile(this.remoteArchivePath).getPath().replace('\\', '/'));
            String scriptName = DEPLOY_APPLICATION_ON_WEBLOGIC_SCRIPT_NAME;
            if (this.hasDeploymentPlan()) {
                argsList.add(rhs.getFile(this.remoteDeploymentPlanPath).getPath().replace('\\', '/'));
                scriptName = DEPLOY_APPLICATION_ON_WEBLOGIC_WITH_PLAN_SCRIPT_NAME;
            }
            boolean bl = (res = this.executeWlstJythonScriptResource(ctx, rhs, scriptName, args = argsList.toArray(new String[argsList.size()]))) == 0;
            return bl;
        }
        finally {
            rhs.close();
        }
    }

    public boolean hasDeploymentPlan() {
        return this.remoteDeploymentPlanPath != null;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setRemoteDeploymentPlanPath(String remoteDeploymentPlanPath) {
        this.remoteDeploymentPlanPath = remoteDeploymentPlanPath;
    }
}

