/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDataSource;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Creates a {@link WlsDataSource JDBC DataSource}.
 */
@SuppressWarnings("serial")
public class CreateWlsDataSourceStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-datasource.py";

	public CreateWlsDataSourceStep(WlsCluster cluster, WlsDataSource wlsDataSource) {
		super("Create datasource " + wlsDataSource + " on cluster " + cluster, cluster.getDomain(), SCRIPT_RESOURCE_PATH, getArgs(
				cluster.getTargetObjectName(), wlsDataSource));
	}

	public CreateWlsDataSourceStep(WlsServer cluster, WlsDataSource wlsDataSource) {
		super("Create datasource " + wlsDataSource + " on server " + cluster, cluster.getDomain(), SCRIPT_RESOURCE_PATH, getArgs(cluster.getTargetObjectName(),
				wlsDataSource));
	}

	private static String[] getArgs(String targetObjectName, WlsDataSource webLogicDatasource) {
		List<String> args = new ArrayList<String>();
		args.add(targetObjectName);
		args.add(webLogicDatasource.getName());
		args.add(webLogicDatasource.getJndiName());
		args.add(webLogicDatasource.getUri());
		if (StringUtils.isBlank(webLogicDatasource.getUserName())) {
			args.add("");
		} else {
			args.add(webLogicDatasource.getUserName());
		}
		if (StringUtils.isBlank(webLogicDatasource.getPassword())) {
			args.add("");
		} else {
			args.add(webLogicDatasource.getPassword());
		}
		args.add(webLogicDatasource.getDriver());
		args.add(String.valueOf(webLogicDatasource.getInit()));
		args.add(String.valueOf(webLogicDatasource.getMax()));
		if (webLogicDatasource.getProperties() != null) {
			args.add(webLogicDatasource.getProperties());
		} else {
			args.add("");
		}
		return args.toArray(new String[args.size()]);
	}

}
