#
# Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys
import os
import time as ptime

ignore = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

print "Connecting to WebLogic"
connect(user, password, url)
edit()
startEdit()

jmsModuleName = sys.argv.pop(0)
subdeploymentName = sys.argv.pop(0)
queueName = sys.argv.pop(0)
jndiName = sys.argv.pop(0)
redeliveryDelayOverride = sys.argv.pop(0)
redeliveryLimits = sys.argv.pop(0)
expirationPolicy = sys.argv.pop(0)
expirationLoggingFormat = sys.argv.pop(0)
errorqueueName = sys.argv.pop(0)

print "Modifying JMS Queue " + queueName + " in Subdeployment " + subdeploymentName + " of JMS Module " + jmsModuleName
cd('/JMSSystemResources/' + jmsModuleName + '/JMSResource/' + jmsModuleName + '/Queues/' + queueName)
cmo.setJNDIName(jndiName)
cmo.setSubDeploymentName(subdeploymentName)
cd('/JMSSystemResources/' + jmsModuleName + '/JMSResource/' + jmsModuleName + '/Queues/' + queueName + '/DeliveryFailureParams/' + queueName )
if errorqueueName != None and len(errorqueueName) > 0:
    cmo.setErrorDestination(getMBean('/JMSSystemResources/' + jmsModuleName + '/JMSResource/' + jmsModuleName + '/Queues/' + errorqueueName))
else:
    cmo.setErrorDestination(None)

cmo.setRedeliveryLimit(int(redeliveryLimits))
cmo.setExpirationPolicy(expirationPolicy)
cmo.setExpirationLoggingPolicy(expirationLoggingFormat)
cd('/JMSSystemResources/' + jmsModuleName + '/JMSResource/' + jmsModuleName + '/Queues/' + queueName + '/DeliveryParamsOverrides/' + queueName )
cmo.setRedeliveryDelay(int(redeliveryDelayOverride))
print "Saving configuration"
save()
disconnect('true')
exit('y')
