/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsStageMode;
import java.util.Map;

public class RetrieveWlsServerStep
implements Step {
    private WlsServer server;

    public RetrieveWlsServerStep(WlsServer server) {
        this.server = server;
    }

    public boolean execute(StepExecutionContext ctx) {
        String containmentpath = "/Servers/" + this.server.getName() + "/ServerStart/" + this.server.getName();
        ctx.logOutput("Retrieving server arguments and classpath");
        Map<String, String> objectOnfo = this.server.getDomain().getObjectInfo(containmentpath);
        if (objectOnfo == null) {
            return false;
        }
        this.server.setArguments(objectOnfo.get("Arguments"));
        if (this.server.getArguments() != null && this.server.getArguments().equals("null")) {
            this.server.setArguments(null);
        }
        this.server.setClasspath(objectOnfo.get("ClassPath"));
        if (this.server.getClasspath() != null && this.server.getClasspath().equals("null")) {
            this.server.setClasspath(null);
        }
        ctx.logOutput("Retrieving server listen port");
        containmentpath = "/Servers/" + this.server.getName();
        objectOnfo = this.server.getDomain().getObjectInfo(containmentpath);
        this.server.setPort(Integer.parseInt(objectOnfo.get("ListenPort")));
        ctx.logOutput("Retrieving server stage mode");
        containmentpath = "/Servers/" + this.server.getName();
        objectOnfo = this.server.getDomain().getObjectInfo(containmentpath);
        String stagedMode = objectOnfo.get("StagingMode");
        if ("nostage".equals(stagedMode)) {
            this.server.setStageMode(WlsStageMode.NoStage);
        } else {
            this.server.setStageMode(WlsStageMode.Stage);
        }
        ctx.logOutput("Retrieving server logging properties");
        containmentpath = "/Servers/" + this.server.getName() + "/Log/" + this.server.getName();
        objectOnfo = this.server.getDomain().getObjectInfo(containmentpath);
        if (objectOnfo != null && objectOnfo.get("RedirectStdoutToServerLogEnabled") != null) {
            this.server.setEnableJVMLogRedirection(Boolean.parseBoolean(objectOnfo.get("RedirectStdoutToServerLogEnabled")));
        } else {
            this.server.setEnableJVMLogRedirection(false);
        }
        if (objectOnfo != null) {
            this.server.setLogFileLocation(objectOnfo.get("FileName"));
        } else {
            this.server.setLogFileLocation(null);
        }
        return true;
    }

    public String getDescription() {
        return "Retrieve properties of WebLogic server \"" + this.server.getLabel() + "\" on host " + this.server.getHost();
    }
}

