/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "This object represents an individual NameList defined on a particular queue manager. Enumerating an object of this class results in an empty list.")
public class WmqNamelist extends BaseConfigurationItem implements WmqResource {

	@ConfigurationItemProperty(required = true, label = "Namelist name", identifying = true, description = "The name of the namelist definition to be changed.The maximum length of the string is MQ_NAMELIST_NAME_LENGTH.", size = Size.LARGE)
	private String nameListName;

	@ConfigurationItemProperty(label = "Names", description = "The names to be placed in the namelist.The names should be given seperated by comma", size = Size.LARGE)
	private String names;

	@ConfigurationItemProperty(label = "NameList Description", description = "This is a plain-text comment that provides descriptive information about the namelist definition.", size = Size.LARGE)
	private String description;

	public String getNameListName() {
		return nameListName;
	}

	public void setNameListName(String nameListName) {
		this.nameListName = nameListName;
	}

	public String getNames() {
		return names;
	}

	public void setNames(String names) {
		this.names = names;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

}
