/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqRemoteQueue;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultBindType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPersistence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPutResponseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPutMessage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

/**
 * Creates a {@link WmqRemoteQueue} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqRemoteQueueStep extends BaseWmqStep {

	public WmqRemoteQueue wmqRemoteQueue;

	@Override
	protected void init() {

		this.mqCommand = MQConstants.MQCMD_CREATE_Q;

	}

	public CreateWmqRemoteQueueStep(WmqRemoteQueue wmqRemoteQueue, WmqQueueManager wmqQmanager)

	{

		this.wmqRemoteQueue = wmqRemoteQueue;
		this.wmqQmanager = wmqQmanager;

	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {

		// Remote Queue name - Mandatory.

		pcfCmd.addParameter(MQConstants.MQCA_Q_NAME, wmqRemoteQueue.getQueueName());

		// Queue Type - Mandatory.This is mentioned here itself.

		pcfCmd.addParameter(MQConstants.MQIA_Q_TYPE, MQConstants.MQQT_REMOTE);

		// Remote Queue Name - Mandatory.This should be a local queue in some other queuemanager other than the one where we are creted this.

		pcfCmd.addParameter(MQConstants.MQCA_REMOTE_Q_NAME, wmqRemoteQueue.getRemoteQueue());

		// Remote QueueManager name - Manadatory.Remote QueeuManager name is the queue manager name other than we are working with.

		pcfCmd.addParameter(MQConstants.MQCA_REMOTE_Q_MGR_NAME, wmqRemoteQueue.getRemoteQueueManager());

		// Default persistent of the Remote Queue may be either Persistent or NotPersistent.
		if (WmqDefaultPersistence.PERSISTENT == wmqRemoteQueue.getDefaultPersistence()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_PERSISTENCE, MQConstants.MQPER_PERSISTENT);
		} else if (WmqDefaultPersistence.NOT_PERSISTENT == wmqRemoteQueue.getDefaultPersistence()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_PERSISTENCE, MQConstants.MQPER_NOT_PERSISTENT);
		}
		// PutMessage value may be either Allowed or Inhibited.
		if (WmqPutMessage.ALLOWED == wmqRemoteQueue.getPutMessages()) {
			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_PUT, MQConstants.MQQA_PUT_ALLOWED);
		} else if (WmqPutMessage.INHIBITED == wmqRemoteQueue.getPutMessages()) {
			pcfCmd.addParameter(MQConstants.MQIA_INHIBIT_PUT, MQConstants.MQQA_PUT_INHIBITED);
		}
		// Description of the RemoteQueue.
		if (wmqRemoteQueue.getDescription() != null && !"".equals(wmqRemoteQueue.getDescription())) {
			pcfCmd.addParameter(MQConstants.MQCA_Q_DESC, wmqRemoteQueue.getDescription());
		}
		// Default Priority for RemoteQueue.
		pcfCmd.addParameter(MQConstants.MQIA_DEF_PRIORITY, wmqRemoteQueue.getDefaultPriority());

		// Scope of the Remote queue.

		if (WmqScope.QUEUE_MANAGER == wmqRemoteQueue.getScope()) {
			pcfCmd.addParameter(MQConstants.MQIA_SCOPE, MQConstants.MQSCO_Q_MGR);
		} else if (WmqScope.CELL == wmqRemoteQueue.getScope()) {
			pcfCmd.addParameter(MQConstants.MQIA_SCOPE, MQConstants.MQSCO_CELL);
		}

		if (wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
			// DefaultPutResponseType value may be either Synchronous or Asynchronous.
			if (WmqDefaultPutResponseType.SYNCHRONOUS == wmqRemoteQueue.getDefaultPutResponseType()) {
				pcfCmd.addParameter(MQConstants.MQIA_DEF_PUT_RESPONSE_TYPE, MQConstants.MQPRT_SYNC_RESPONSE);
			} else if (WmqDefaultPutResponseType.ASYNCHRONOUS == wmqRemoteQueue.getDefaultPutResponseType()) {
				pcfCmd.addParameter(MQConstants.MQIA_DEF_PUT_RESPONSE_TYPE, MQConstants.MQPRT_ASYNC_RESPONSE);
			}

		}
		// TransmissionQueue is the Transmission queue name.
		if (wmqRemoteQueue.getTransmissionQueue() != null && !"".equals(wmqRemoteQueue.getTransmissionQueue())) {
			pcfCmd.addParameter(MQConstants.MQCA_XMIT_Q_NAME, wmqRemoteQueue.getTransmissionQueue());
		}
		// DefaultBindType value may be either OnOpen or NotFixed.
		if (WmqDefaultBindType.ON_OPEN == wmqRemoteQueue.getDefaultBindType()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_BIND, MQConstants.MQBND_BIND_ON_OPEN);
		} else if (WmqDefaultBindType.NOT_FIXED == wmqRemoteQueue.getDefaultBindType()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_BIND, MQConstants.MQBND_BIND_NOT_FIXED);
		}
		if (wmqRemoteQueue.getClusterName() != null && wmqRemoteQueue.getClusterNamelist() != null) {
			throw new MQPluginException("Clustername and Cluster Namelist both should not be given at a time in CI");
		}

		// ClusterName is the name of the cluster to which the queue belongs.
		if (StringUtils.isNotBlank(wmqRemoteQueue.getClusterName())) {
			pcfCmd.addParameter(MQConstants.MQCA_CLUSTER_NAME, wmqRemoteQueue.getClusterName());
		}
		// ClusterNamelistName is the name of the namelist, that specifies a list of clusters to which the queue belongs.
		if (StringUtils.isNotBlank(wmqRemoteQueue.getClusterNamelist())) {
			pcfCmd.addParameter(MQConstants.MQCA_CLUSTER_NAMELIST, wmqRemoteQueue.getClusterNamelist());
		}
		// CLWLqueuerank consists of the value in the range through 0 to 9.
		pcfCmd.addParameter(MQConstants.MQIA_CLWL_Q_RANK, wmqRemoteQueue.getClwlQueueRank());
		// CLWLqueuepriority consists of the value in the range through 0 to 9.
		pcfCmd.addParameter(MQConstants.MQIA_CLWL_Q_PRIORITY, wmqRemoteQueue.getClwlQueueRank());

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating RemoteQueue \"" + wmqRemoteQueue.getQueueName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Creating RemoteQueue Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The RemoteQueue \"" + wmqRemoteQueue.getQueueName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";

	}

}
