/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqTopic;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;

public class DestroyWmqTopicStep
extends BaseWmqStep {
    private WmqTopic wmqTopic;

    public DestroyWmqTopicStep(WmqTopic wmqTopic, WmqQueueManager wmqQmanager) {
        this.wmqTopic = wmqTopic;
        this.wmqQmanager = wmqQmanager;
    }

    protected void init() {
        if (this.wmqQmanager.getVersion() == WmqVersion.WMQ_60) {
            throw new ResolutionException("Topic is not supported in MQV6");
        }
        this.mqCommand = 173;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        pcfCmd.addParameter(2092, this.wmqTopic.getTopicName());
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Deleting Topic \"" + this.wmqTopic.getTopicName() + "\" from QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Deleting Topic with PCF";
    }

    protected String getSuccessMessage() {
        return "The Topic \"" + this.wmqTopic.getTopicName() + "\" is deleted from QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

