/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Environment;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqAliasQueueToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqClusterReceiverChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqClusterSenderChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqLU62ListenerToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqLocalQueueToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqModelQueueToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqNamelistToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqNetBIOSListenerToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqProcessDefinitionToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqReceiverChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqRemoteQueueToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqRequesterChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqSPXListenerToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqSenderChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqServerChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqServerConnectionChannelToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqSubscriptionsToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqTCPListenerToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.mapper.WmqTopicToWmqQueueManagerMapper;
import com.xebialabs.deployit.plugin.wmq.step.DisplayWmqCmdServerStatusStep;
import com.xebialabs.deployit.plugin.wmq.step.DisplayWmqQueueManagerStatusStep;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WmqDeploymentRunBook
extends SingleTypeHandlingRunBook<Deployment> {
    public WmqDeploymentRunBook() {
        super(Deployment.class);
    }

    protected void resolve(Change<Deployment> change, ChangePlan changePlan, List<Step> steps) {
        WmqSenderChannelToWmqQueueManagerMapper senderChannelToQueueManagerMapper = new WmqSenderChannelToWmqQueueManagerMapper(change);
        WmqReceiverChannelToWmqQueueManagerMapper receiverChannelToQueueManagerMapper = new WmqReceiverChannelToWmqQueueManagerMapper(change);
        WmqServerChannelToWmqQueueManagerMapper serverChannelToQueueManagerMapper = new WmqServerChannelToWmqQueueManagerMapper(change);
        WmqServerConnectionChannelToWmqQueueManagerMapper serverConnectionChannelToQueueManagerMapper = new WmqServerConnectionChannelToWmqQueueManagerMapper(change);
        WmqClusterSenderChannelToWmqQueueManagerMapper clusterSenderChannelToQueueManagerMapper = new WmqClusterSenderChannelToWmqQueueManagerMapper(change);
        WmqClusterReceiverChannelToWmqQueueManagerMapper clusterReceiverChannelToQueueManagerMapper = new WmqClusterReceiverChannelToWmqQueueManagerMapper(change);
        WmqRequesterChannelToWmqQueueManagerMapper requesterChannelToQueueManagerMapper = new WmqRequesterChannelToWmqQueueManagerMapper(change);
        WmqLocalQueueToWmqQueueManagerMapper localqToQmgrMapper = new WmqLocalQueueToWmqQueueManagerMapper(change);
        WmqAliasQueueToWmqQueueManagerMapper aliasqToQmgrMapper = new WmqAliasQueueToWmqQueueManagerMapper(change);
        WmqModelQueueToWmqQueueManagerMapper modelqToQmgrMapper = new WmqModelQueueToWmqQueueManagerMapper(change);
        WmqRemoteQueueToWmqQueueManagerMapper remoteqToQmgrMapper = new WmqRemoteQueueToWmqQueueManagerMapper(change);
        WmqProcessDefinitionToWmqQueueManagerMapper processToQmgrMapper = new WmqProcessDefinitionToWmqQueueManagerMapper(change);
        WmqNamelistToWmqQueueManagerMapper namelistToQmgrMapper = new WmqNamelistToWmqQueueManagerMapper(change);
        WmqTopicToWmqQueueManagerMapper topicToQueueManager = new WmqTopicToWmqQueueManagerMapper(change);
        WmqSubscriptionsToWmqQueueManagerMapper subscriptionsToQueueManager = new WmqSubscriptionsToWmqQueueManagerMapper(change);
        WmqTCPListenerToWmqQueueManagerMapper tcpListenerToQueueManager = new WmqTCPListenerToWmqQueueManagerMapper(change);
        WmqNetBIOSListenerToWmqQueueManagerMapper netbiosListenerToQueueManager = new WmqNetBIOSListenerToWmqQueueManagerMapper(change);
        WmqLU62ListenerToWmqQueueManagerMapper lu62ListenerToQueueManager = new WmqLU62ListenerToWmqQueueManagerMapper(change);
        WmqSPXListenerToWmqQueueManagerMapper spxListenerToQueueManager = new WmqSPXListenerToWmqQueueManagerMapper(change);
        if (!this.isMQDeployment(senderChannelToQueueManagerMapper, receiverChannelToQueueManagerMapper, serverChannelToQueueManagerMapper, serverConnectionChannelToQueueManagerMapper, clusterSenderChannelToQueueManagerMapper, clusterReceiverChannelToQueueManagerMapper, requesterChannelToQueueManagerMapper, localqToQmgrMapper, aliasqToQmgrMapper, modelqToQmgrMapper, remoteqToQmgrMapper, processToQmgrMapper, namelistToQmgrMapper, topicToQueueManager, subscriptionsToQueueManager, tcpListenerToQueueManager, netbiosListenerToQueueManager, lu62ListenerToQueueManager, spxListenerToQueueManager)) {
            return;
        }
        Set<WmqQueueManager> queueManagerChanges = this.findWmqQueueManagerChangesForDeploymentChange(change);
        if (queueManagerChanges != null) {
            for (WmqQueueManager eachQueueManagerChange : queueManagerChanges) {
                steps.add(new DisplayWmqQueueManagerStatusStep(eachQueueManagerChange, true));
                steps.add(new DisplayWmqCmdServerStatusStep(eachQueueManagerChange, true));
            }
        }
        clusterSenderChannelToQueueManagerMapper.generateDeletionSteps(steps);
        clusterReceiverChannelToQueueManagerMapper.generateDeletionSteps(steps);
        requesterChannelToQueueManagerMapper.generateDeletionSteps(steps);
        serverChannelToQueueManagerMapper.generateDeletionSteps(steps);
        senderChannelToQueueManagerMapper.generateDeletionSteps(steps);
        receiverChannelToQueueManagerMapper.generateDeletionSteps(steps);
        serverConnectionChannelToQueueManagerMapper.generateDeletionSteps(steps);
        namelistToQmgrMapper.generateDeletionSteps(steps);
        processToQmgrMapper.generateDeletionSteps(steps);
        remoteqToQmgrMapper.generateDeletionSteps(steps);
        localqToQmgrMapper.generateDeletionSteps(steps);
        aliasqToQmgrMapper.generateDeletionSteps(steps);
        modelqToQmgrMapper.generateDeletionSteps(steps);
        topicToQueueManager.generateDeletionSteps(steps);
        subscriptionsToQueueManager.generateDeletionSteps(steps);
        tcpListenerToQueueManager.generateDeletionSteps(steps);
        netbiosListenerToQueueManager.generateDeletionSteps(steps);
        lu62ListenerToQueueManager.generateDeletionSteps(steps);
        spxListenerToQueueManager.generateDeletionSteps(steps);
        senderChannelToQueueManagerMapper.generateModificationSteps(steps);
        receiverChannelToQueueManagerMapper.generateModificationSteps(steps);
        requesterChannelToQueueManagerMapper.generateModificationSteps(steps);
        serverChannelToQueueManagerMapper.generateModificationSteps(steps);
        serverConnectionChannelToQueueManagerMapper.generateModificationSteps(steps);
        clusterSenderChannelToQueueManagerMapper.generateModificationSteps(steps);
        clusterReceiverChannelToQueueManagerMapper.generateModificationSteps(steps);
        namelistToQmgrMapper.generateModificationSteps(steps);
        processToQmgrMapper.generateModificationSteps(steps);
        remoteqToQmgrMapper.generateModificationSteps(steps);
        localqToQmgrMapper.generateModificationSteps(steps);
        aliasqToQmgrMapper.generateModificationSteps(steps);
        modelqToQmgrMapper.generateModificationSteps(steps);
        topicToQueueManager.generateModificationSteps(steps);
        subscriptionsToQueueManager.generateModificationSteps(steps);
        tcpListenerToQueueManager.generateModificationSteps(steps);
        netbiosListenerToQueueManager.generateModificationSteps(steps);
        lu62ListenerToQueueManager.generateModificationSteps(steps);
        spxListenerToQueueManager.generateModificationSteps(steps);
        topicToQueueManager.generateAdditionSteps(steps);
        subscriptionsToQueueManager.generateAdditionSteps(steps);
        tcpListenerToQueueManager.generateAdditionSteps(steps);
        netbiosListenerToQueueManager.generateAdditionSteps(steps);
        lu62ListenerToQueueManager.generateAdditionSteps(steps);
        spxListenerToQueueManager.generateAdditionSteps(steps);
        clusterReceiverChannelToQueueManagerMapper.generateAdditionSteps(steps);
        clusterSenderChannelToQueueManagerMapper.generateAdditionSteps(steps);
        serverChannelToQueueManagerMapper.generateAdditionSteps(steps);
        requesterChannelToQueueManagerMapper.generateAdditionSteps(steps);
        receiverChannelToQueueManagerMapper.generateAdditionSteps(steps);
        senderChannelToQueueManagerMapper.generateAdditionSteps(steps);
        serverConnectionChannelToQueueManagerMapper.generateAdditionSteps(steps);
        namelistToQmgrMapper.generateAdditionSteps(steps);
        processToQmgrMapper.generateAdditionSteps(steps);
        remoteqToQmgrMapper.generateAdditionSteps(steps);
        localqToQmgrMapper.generateAdditionSteps(steps);
        aliasqToQmgrMapper.generateAdditionSteps(steps);
        modelqToQmgrMapper.generateAdditionSteps(steps);
    }

    private boolean isMQDeployment(WmqSenderChannelToWmqQueueManagerMapper senderChannelToQueueManagerMapper, WmqReceiverChannelToWmqQueueManagerMapper receiverChannelToQueueManagerMapper, WmqServerChannelToWmqQueueManagerMapper serverChannelToQueueManagerMapper, WmqServerConnectionChannelToWmqQueueManagerMapper serverConnectionChannelToQueueManagerMapper, WmqClusterSenderChannelToWmqQueueManagerMapper clusterSenderChannelToQueueManagerMapper, WmqClusterReceiverChannelToWmqQueueManagerMapper clusterReceiverChannelToQueueManagerMapper, WmqRequesterChannelToWmqQueueManagerMapper requesterChannelToQueueManagerMapper, WmqLocalQueueToWmqQueueManagerMapper localqToQmgrMapper, WmqAliasQueueToWmqQueueManagerMapper aliasqToQmgrMapper, WmqModelQueueToWmqQueueManagerMapper modelqToQmgrMapper, WmqRemoteQueueToWmqQueueManagerMapper remoteqToQmgrMapper, WmqProcessDefinitionToWmqQueueManagerMapper processToQmgrMapper, WmqNamelistToWmqQueueManagerMapper namelistToQmgrMapper, WmqTopicToWmqQueueManagerMapper topicToQueueManager, WmqSubscriptionsToWmqQueueManagerMapper subscriptionsToQueueManager, WmqTCPListenerToWmqQueueManagerMapper tcpListenerToQueueManager, WmqNetBIOSListenerToWmqQueueManagerMapper netbiosListenerToQueueManager, WmqLU62ListenerToWmqQueueManagerMapper lu62ListenerToQueueManager, WmqSPXListenerToWmqQueueManagerMapper spxListenerToQueueManager) {
        HashSet affectedQueueManager = new HashSet();
        affectedQueueManager.addAll(senderChannelToQueueManagerMapper.getAffectedTargets());
        affectedQueueManager.addAll(receiverChannelToQueueManagerMapper.getAffectedTargets());
        affectedQueueManager.addAll(requesterChannelToQueueManagerMapper.getAffectedTargets());
        affectedQueueManager.addAll(serverChannelToQueueManagerMapper.getAffectedTargets());
        affectedQueueManager.addAll(serverConnectionChannelToQueueManagerMapper.getAffectedTargets());
        affectedQueueManager.addAll(clusterSenderChannelToQueueManagerMapper.getAffectedTargets());
        affectedQueueManager.addAll(clusterReceiverChannelToQueueManagerMapper.getAffectedTargets());
        affectedQueueManager.addAll(localqToQmgrMapper.getAffectedTargets());
        affectedQueueManager.addAll(aliasqToQmgrMapper.getAffectedTargets());
        affectedQueueManager.addAll(modelqToQmgrMapper.getAffectedTargets());
        affectedQueueManager.addAll(remoteqToQmgrMapper.getAffectedTargets());
        affectedQueueManager.addAll(processToQmgrMapper.getAffectedTargets());
        affectedQueueManager.addAll(namelistToQmgrMapper.getAffectedTargets());
        affectedQueueManager.addAll(topicToQueueManager.getAffectedTargets());
        affectedQueueManager.addAll(subscriptionsToQueueManager.getAffectedTargets());
        affectedQueueManager.addAll(tcpListenerToQueueManager.getAffectedTargets());
        affectedQueueManager.addAll(netbiosListenerToQueueManager.getAffectedTargets());
        affectedQueueManager.addAll(lu62ListenerToQueueManager.getAffectedTargets());
        affectedQueueManager.addAll(spxListenerToQueueManager.getAffectedTargets());
        return !affectedQueueManager.isEmpty();
    }

    private Set<WmqQueueManager> findWmqQueueManagerChangesForDeploymentChange(Change<Deployment> deploymentChange) {
        return this.getQueueManagerDeploymentTarget((Deployment)deploymentChange.getNewRevision());
    }

    private Set<WmqQueueManager> getQueueManagerDeploymentTarget(Deployment deployment) {
        Set queueManagerChanges = null;
        if (deployment != null) {
            Environment env = deployment.getTarget();
            queueManagerChanges = env.getMembersOfType(WmqQueueManager.class);
        }
        return queueManagerChanges;
    }
}

