/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqLocalQueue;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqCLWLUseQueue;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultBindType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultInputOpenOption;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPersistence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPutResponseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultReadAhead;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDistributionLists;
import com.xebialabs.deployit.plugin.wmq.enums.WmqGetMessages;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHardengetBackout;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageDeliverySequence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNPMClass;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPutMessage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueAccounting;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthHighEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthLowEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthMaxEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueServiceIntervalEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueStatistics;
import com.xebialabs.deployit.plugin.wmq.enums.WmqScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqShareability;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTriggerControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTriggerType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqUsage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

public class CreateWmqLocalQueueStep
extends BaseWmqStep {
    public WmqLocalQueue wmqLocalQueue;

    protected void init() {
        this.mqCommand = 11;
    }

    public CreateWmqLocalQueueStep(WmqLocalQueue wmqLocalQueue, WmqQueueManager wmqQmanager) {
        this.wmqLocalQueue = wmqLocalQueue;
        this.wmqQmanager = wmqQmanager;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {
        pcfCmd.addParameter(2016, this.wmqLocalQueue.getQueueName());
        pcfCmd.addParameter(20, 1);
        if (WmqDefaultPersistence.PERSISTENT == this.wmqLocalQueue.getDefaultPersistence()) {
            pcfCmd.addParameter(5, 1);
        } else if (WmqDefaultPersistence.NOT_PERSISTENT == this.wmqLocalQueue.getDefaultPersistence()) {
            pcfCmd.addParameter(5, 0);
        }
        if (WmqScope.QUEUE_MANAGER == this.wmqLocalQueue.getScope()) {
            pcfCmd.addParameter(45, 1);
        } else if (WmqScope.CELL == this.wmqLocalQueue.getScope()) {
            pcfCmd.addParameter(45, 2);
        }
        pcfCmd.addParameter(95, this.wmqLocalQueue.getClwlQueueRank());
        pcfCmd.addParameter(96, this.wmqLocalQueue.getClwlQueuePriority());
        pcfCmd.addParameter(6, this.wmqLocalQueue.getDefaultPriority());
        if (WmqPutMessage.ALLOWED == this.wmqLocalQueue.getPutMessages()) {
            pcfCmd.addParameter(10, 0);
        } else if (WmqPutMessage.INHIBITED == this.wmqLocalQueue.getPutMessages()) {
            pcfCmd.addParameter(10, 1);
        }
        if (this.wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
            if (WmqDefaultPutResponseType.SYNCHRONOUS == this.wmqLocalQueue.getDefaultPutResponseType()) {
                pcfCmd.addParameter(184, 1);
            } else if (WmqDefaultPutResponseType.ASYNCHRONOUS == this.wmqLocalQueue.getDefaultPutResponseType()) {
                pcfCmd.addParameter(184, 2);
            }
            if (WmqPropertyControl.COMPATABILITY == this.wmqLocalQueue.getPropertyControl()) {
                pcfCmd.addParameter(190, 0);
            } else if (WmqPropertyControl.NONE == this.wmqLocalQueue.getPropertyControl()) {
                pcfCmd.addParameter(190, 1);
            } else if (WmqPropertyControl.ALL == this.wmqLocalQueue.getPropertyControl()) {
                pcfCmd.addParameter(190, 2);
            } else if (WmqPropertyControl.FORCE_MQ_RFH2 == this.wmqLocalQueue.getPropertyControl()) {
                pcfCmd.addParameter(190, 3);
            }
            if (WmqDefaultReadAhead.YES == this.wmqLocalQueue.getDefaultReadAhead()) {
                pcfCmd.addParameter(188, 1);
            } else if (WmqDefaultReadAhead.NO == this.wmqLocalQueue.getDefaultReadAhead()) {
                pcfCmd.addParameter(188, 0);
            } else if (WmqDefaultReadAhead.DISABLED == this.wmqLocalQueue.getDefaultReadAhead()) {
                pcfCmd.addParameter(188, 2);
            }
        }
        if (WmqGetMessages.ALLOWED == this.wmqLocalQueue.getGetMessages()) {
            pcfCmd.addParameter(9, 0);
        } else if (WmqGetMessages.INHIBITED == this.wmqLocalQueue.getGetMessages()) {
            pcfCmd.addParameter(9, 1);
        }
        if (StringUtils.isNotBlank(this.wmqLocalQueue.getDescription())) {
            pcfCmd.addParameter(2013, this.wmqLocalQueue.getDescription());
        }
        pcfCmd.addParameter(15, this.wmqLocalQueue.getMaxQueueDepth());
        pcfCmd.addParameter(13, this.wmqLocalQueue.getMaxMessageLength());
        if (WmqDefaultInputOpenOption.INPUT_EXCLUSIVE == this.wmqLocalQueue.getDefaultInputOpenOption()) {
            pcfCmd.addParameter(4, 4);
        } else if (WmqDefaultInputOpenOption.INPUT_SHARED == this.wmqLocalQueue.getDefaultInputOpenOption()) {
            pcfCmd.addParameter(4, 2);
        }
        if (WmqShareability.SHAREABLE == this.wmqLocalQueue.getShareability()) {
            pcfCmd.addParameter(23, 1);
        } else if (WmqShareability.NOT_SHAREABLE == this.wmqLocalQueue.getShareability()) {
            pcfCmd.addParameter(23, 0);
        }
        pcfCmd.addParameter(21, this.wmqLocalQueue.getRetentionInterval());
        if (WmqDistributionLists.SUPPORTED == this.wmqLocalQueue.getDistributionLists()) {
            pcfCmd.addParameter(34, 1);
        } else if (WmqDistributionLists.NOT_SUPPORTED == this.wmqLocalQueue.getDistributionLists()) {
            pcfCmd.addParameter(34, 0);
        }
        if (WmqCLWLUseQueue.QUEUE_MANAGER == this.wmqLocalQueue.getClwlUseQueue()) {
            pcfCmd.addParameter(98, -3);
        } else if (WmqCLWLUseQueue.ANY == this.wmqLocalQueue.getClwlUseQueue()) {
            pcfCmd.addParameter(98, 1);
        } else if (WmqCLWLUseQueue.LOCAL == this.wmqLocalQueue.getClwlUseQueue()) {
            pcfCmd.addParameter(98, 0);
        }
        if (WmqTriggerControl.OFF == this.wmqLocalQueue.getTriggerControl()) {
            pcfCmd.addParameter(24, 0);
        } else if (WmqTriggerControl.ON == this.wmqLocalQueue.getTriggerControl()) {
            pcfCmd.addParameter(24, 1);
        }
        if (WmqTriggerType.DEPTH == this.wmqLocalQueue.getTriggerType()) {
            pcfCmd.addParameter(28, 3);
        } else if (WmqTriggerType.EVERY == this.wmqLocalQueue.getTriggerType()) {
            pcfCmd.addParameter(28, 2);
        } else if (WmqTriggerType.FIRST == this.wmqLocalQueue.getTriggerType()) {
            pcfCmd.addParameter(28, 1);
        } else if (WmqTriggerType.NONE == this.wmqLocalQueue.getTriggerType()) {
            pcfCmd.addParameter(28, 0);
        }
        if (this.wmqLocalQueue.getTriggerDepth() != 0) {
            pcfCmd.addParameter(29, this.wmqLocalQueue.getTriggerDepth());
        }
        pcfCmd.addParameter(26, this.wmqLocalQueue.getTriggerMessagePriority());
        if (this.wmqLocalQueue.getTriggerData() != null && !"".equals(this.wmqLocalQueue.getTriggerData())) {
            pcfCmd.addParameter(2023, this.wmqLocalQueue.getTriggerData());
        }
        if (this.wmqLocalQueue.getInitiationQueue() != null && !"".equals(this.wmqLocalQueue.getInitiationQueue())) {
            pcfCmd.addParameter(2008, this.wmqLocalQueue.getInitiationQueue());
        }
        if (this.wmqLocalQueue.getProcessName() != null && !"".equals(this.wmqLocalQueue.getProcessName())) {
            pcfCmd.addParameter(2012, this.wmqLocalQueue.getProcessName());
        }
        if (WmqQueueDepthMaxEvents.ENABLED == this.wmqLocalQueue.getQueueDepthMaxEvents()) {
            pcfCmd.addParameter(42, 1);
        } else if (WmqQueueDepthMaxEvents.DISABLED == this.wmqLocalQueue.getQueueDepthMaxEvents()) {
            pcfCmd.addParameter(42, 0);
        }
        if (WmqQueueDepthHighEvents.ENABLED == this.wmqLocalQueue.getQueueDepthHighEvents()) {
            pcfCmd.addParameter(43, 1);
        } else if (WmqQueueDepthHighEvents.DISABLED == this.wmqLocalQueue.getQueueDepthHighEvents()) {
            pcfCmd.addParameter(43, 0);
        }
        pcfCmd.addParameter(40, this.wmqLocalQueue.getQueueDepthHighLimit());
        pcfCmd.addParameter(41, this.wmqLocalQueue.getQueueDepthLowLimit());
        if (WmqQueueDepthLowEvents.ENABLED == this.wmqLocalQueue.getQueueDepthLowEvents()) {
            pcfCmd.addParameter(44, 1);
        } else if (WmqQueueDepthLowEvents.DISABLED == this.wmqLocalQueue.getQueueDepthLowEvents()) {
            pcfCmd.addParameter(44, 0);
        }
        if (WmqQueueServiceIntervalEvents.HIGH == this.wmqLocalQueue.getQueueServiceIntervalEvents()) {
            pcfCmd.addParameter(46, 1);
        } else if (WmqQueueServiceIntervalEvents.OK == this.wmqLocalQueue.getQueueServiceIntervalEvents()) {
            pcfCmd.addParameter(46, 2);
        } else if (WmqQueueServiceIntervalEvents.NONE == this.wmqLocalQueue.getQueueServiceIntervalEvents()) {
            pcfCmd.addParameter(46, 0);
        }
        pcfCmd.addParameter(54, this.wmqLocalQueue.getQueueServiceInterval());
        if (this.wmqLocalQueue.getBackoutRequeueQueue() != null && !"".equals(this.wmqLocalQueue.getBackoutRequeueQueue())) {
            pcfCmd.addParameter(2019, this.wmqLocalQueue.getBackoutRequeueQueue());
        }
        pcfCmd.addParameter(22, this.wmqLocalQueue.getBackoutThreshold());
        if (WmqHardengetBackout.HARDENED == this.wmqLocalQueue.getHardengetBackout()) {
            pcfCmd.addParameter(8, 1);
        } else if (WmqHardengetBackout.NOT_HARDENED == this.wmqLocalQueue.getHardengetBackout()) {
            pcfCmd.addParameter(8, 0);
        }
        if (WmqNPMClass.NORMAL == this.wmqLocalQueue.getNpmClass()) {
            pcfCmd.addParameter(78, 0);
        } else if (WmqNPMClass.HIGH == this.wmqLocalQueue.getNpmClass()) {
            pcfCmd.addParameter(78, 10);
        }
        if (WmqQueueMonitoring.HIGH == this.wmqLocalQueue.getQueueMonitoring()) {
            pcfCmd.addParameter(123, 65);
        } else if (WmqQueueMonitoring.LOW == this.wmqLocalQueue.getQueueMonitoring()) {
            pcfCmd.addParameter(123, 17);
        } else if (WmqQueueMonitoring.MEDIUM == this.wmqLocalQueue.getQueueMonitoring()) {
            pcfCmd.addParameter(123, 33);
        } else if (WmqQueueMonitoring.QUEUE_MANAGER == this.wmqLocalQueue.getQueueMonitoring()) {
            pcfCmd.addParameter(123, -3);
        } else if (WmqQueueMonitoring.OFF == this.wmqLocalQueue.getQueueMonitoring()) {
            pcfCmd.addParameter(123, 0);
        }
        if (WmqQueueStatistics.ON == this.wmqLocalQueue.getQueueStatistics()) {
            pcfCmd.addParameter(128, 1);
        } else if (WmqQueueStatistics.OFF == this.wmqLocalQueue.getQueueStatistics()) {
            pcfCmd.addParameter(128, 0);
        } else if (WmqQueueStatistics.QUEUE_MANAGER == this.wmqLocalQueue.getQueueStatistics()) {
            pcfCmd.addParameter(128, -3);
        }
        if (WmqQueueAccounting.ON == this.wmqLocalQueue.getQueueAccounting()) {
            pcfCmd.addParameter(134, 1);
        } else if (WmqQueueAccounting.OFF == this.wmqLocalQueue.getQueueAccounting()) {
            pcfCmd.addParameter(134, 0);
        } else if (WmqQueueAccounting.QUEUE_MANAGER == this.wmqLocalQueue.getQueueAccounting()) {
            pcfCmd.addParameter(134, -3);
        }
        if (WmqMessageDeliverySequence.PRIORITY == this.wmqLocalQueue.getMessageDeliverySequence()) {
            pcfCmd.addParameter(16, 0);
        } else if (WmqMessageDeliverySequence.FIFO == this.wmqLocalQueue.getMessageDeliverySequence()) {
            pcfCmd.addParameter(16, 1);
        }
        if (WmqUsage.NORMAL == this.wmqLocalQueue.getUsage()) {
            pcfCmd.addParameter(12, 0);
        } else if (WmqUsage.TRANSMISSION == this.wmqLocalQueue.getUsage()) {
            pcfCmd.addParameter(12, 1);
        }
        if (WmqDefaultBindType.ON_OPEN == this.wmqLocalQueue.getDefaultBindType()) {
            pcfCmd.addParameter(61, 0);
        } else if (WmqDefaultBindType.NOT_FIXED == this.wmqLocalQueue.getDefaultBindType()) {
            pcfCmd.addParameter(61, 1);
        }
        if (this.wmqLocalQueue.getClusterName() != null && this.wmqLocalQueue.getClusterNamelist() != null) {
            throw new MQPluginException("Clustername and Cluster Namelist both should not be given at a time in CI");
        }
        if (StringUtils.isNotBlank(this.wmqLocalQueue.getClusterName())) {
            pcfCmd.addParameter(2029, this.wmqLocalQueue.getClusterName());
        }
        if (StringUtils.isNotBlank(this.wmqLocalQueue.getClusterNamelist())) {
            pcfCmd.addParameter(2030, this.wmqLocalQueue.getClusterNamelist());
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating LocalQueue \"" + this.wmqLocalQueue.getQueueName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating LocalQueue Step";
    }

    protected String getSuccessMessage() {
        return "The LocalQueue \"" + this.wmqLocalQueue.getQueueName() + "\" is created on QueueManager\"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

