/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.distribution;

import com.xebialabs.xlplatform.distribution.RSAInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;

public final class RSAUtils$ {
    public static final RSAUtils$ MODULE$ = new RSAUtils$();
    private static final SecureRandom random = new SecureRandom();
    private static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);

    private final SecureRandom random() {
        return random;
    }

    private final BigInteger defaultPublicExponent() {
        return defaultPublicExponent;
    }

    private final int defaultTests() {
        return 12;
    }

    private RSAKeyPairGenerator newKeyPairGenerator() {
        return new RSAKeyPairGenerator();
    }

    private RSADigestSigner newSigner() {
        return new RSADigestSigner((Digest)new SHA256Digest());
    }

    public RSAInfo generateKeyPair() {
        RSAKeyPairGenerator keyPairGenerator = this.newKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new RSAKeyGenerationParameters(this.defaultPublicExponent(), this.random(), 2048, 12));
        AsymmetricCipherKeyPair keyPair = keyPairGenerator.generateKeyPair();
        return new RSAInfo((RSAKeyParameters)keyPair.getPrivate(), SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)keyPair.getPublic()).getEncoded());
    }

    public String sign(String message, RSAKeyParameters privateKey) throws Exception {
        RSADigestSigner signer = this.newSigner();
        signer.init(true, (CipherParameters)privateKey);
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        signer.update(bytes, 0, bytes.length);
        return Base64.getEncoder().encodeToString(signer.generateSignature());
    }

    public boolean verify(String message, String signature, byte[] publicKeyEncoded) throws Exception {
        AsymmetricKeyParameter publicKeyParameter = PublicKeyFactory.createKey((InputStream)new ByteArrayInputStream(publicKeyEncoded));
        RSADigestSigner signer = this.newSigner();
        signer.init(false, (CipherParameters)publicKeyParameter);
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        signer.update(bytes, 0, bytes.length);
        byte[] signatureBytes = Base64.getDecoder().decode(signature);
        return signer.verifySignature(signatureBytes);
    }

    private RSAUtils$() {
    }
}

