/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hpack;

import com.twitter.hpack.HeaderField;

final class DynamicTable {
    HeaderField[] headerFields;
    int head;
    int tail;
    private int size;
    private int capacity = -1;

    DynamicTable(int initialCapacity) {
        this.setCapacity(initialCapacity);
    }

    public int length() {
        int length = this.head < this.tail ? this.headerFields.length - this.tail + this.head : this.head - this.tail;
        return length;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public HeaderField getEntry(int index) {
        if (index <= 0 || index > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        int i = this.head - index;
        if (i < 0) {
            return this.headerFields[i + this.headerFields.length];
        }
        return this.headerFields[i];
    }

    public void add(HeaderField header) {
        int headerSize = header.size();
        if (headerSize > this.capacity) {
            this.clear();
            return;
        }
        while (this.size + headerSize > this.capacity) {
            this.remove();
        }
        this.headerFields[this.head++] = header;
        this.size += header.size();
        if (this.head == this.headerFields.length) {
            this.head = 0;
        }
    }

    public HeaderField remove() {
        HeaderField removed = this.headerFields[this.tail];
        if (removed == null) {
            return null;
        }
        this.size -= removed.size();
        this.headerFields[this.tail++] = null;
        if (this.tail == this.headerFields.length) {
            this.tail = 0;
        }
        return removed;
    }

    public void clear() {
        while (this.tail != this.head) {
            this.headerFields[this.tail++] = null;
            if (this.tail != this.headerFields.length) continue;
            this.tail = 0;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    public void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + capacity);
        }
        if (this.capacity == capacity) {
            return;
        }
        this.capacity = capacity;
        if (capacity == 0) {
            this.clear();
        } else {
            while (this.size > capacity) {
                this.remove();
            }
        }
        int maxEntries = capacity / 32;
        if (capacity % 32 != 0) {
            ++maxEntries;
        }
        if (this.headerFields != null && this.headerFields.length == maxEntries) {
            return;
        }
        HeaderField[] tmp = new HeaderField[maxEntries];
        int len = this.length();
        int cursor = this.tail;
        for (int i = 0; i < len; ++i) {
            HeaderField entry;
            tmp[i] = entry = this.headerFields[cursor++];
            if (cursor != this.headerFields.length) continue;
            cursor = 0;
        }
        this.tail = 0;
        this.head = this.tail + len;
        this.headerFields = tmp;
    }
}

