/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.EpochNanoClock;

public class OffsetEpochNanoClock
implements EpochNanoClock {
    private static final int DEFAULT_MAX_MEASUREMENT_RETRIES = 100;
    private static final long DEFAULT_MEASUREMENT_THRESHOLD_NS = 250L;
    private static final long DEFAULT_RESAMPLE_INTERVAL_NS = TimeUnit.HOURS.toNanos(1L);
    private final int maxMeasurementRetries;
    private final long measurementThresholdNs;
    private final long resampleIntervalNs;
    private long initialNanoTime;
    private long initialCurrentNanoTime;
    private boolean isWithinThreshold;

    public OffsetEpochNanoClock() {
        this(100, 250L, DEFAULT_RESAMPLE_INTERVAL_NS);
    }

    public OffsetEpochNanoClock(int maxMeasurementRetries, long measurementThresholdNs, long resampleIntervalNs) {
        this.maxMeasurementRetries = maxMeasurementRetries;
        this.measurementThresholdNs = measurementThresholdNs;
        this.resampleIntervalNs = resampleIntervalNs;
        this.sample();
    }

    public void sample() {
        long bestInitialCurrentNanoTime = 0L;
        long bestInitialNanoTime = 0L;
        long bestNanoTimeWindow = Long.MAX_VALUE;
        for (int i = 0; i < this.maxMeasurementRetries; ++i) {
            long firstNanoTime = System.nanoTime();
            long initialCurrentTimeMillis = System.currentTimeMillis();
            long secondNanoTime = System.nanoTime();
            long nanoTimeWindow = secondNanoTime - firstNanoTime;
            if (nanoTimeWindow < this.measurementThresholdNs) {
                this.initialCurrentNanoTime = TimeUnit.MILLISECONDS.toNanos(initialCurrentTimeMillis);
                this.initialNanoTime = firstNanoTime + secondNanoTime >> 1;
                this.isWithinThreshold = true;
                return;
            }
            if (nanoTimeWindow >= bestNanoTimeWindow) continue;
            bestInitialCurrentNanoTime = TimeUnit.MILLISECONDS.toNanos(initialCurrentTimeMillis);
            bestInitialNanoTime = firstNanoTime + secondNanoTime >> 1;
            bestNanoTimeWindow = nanoTimeWindow;
        }
        this.initialCurrentNanoTime = bestInitialCurrentNanoTime;
        this.initialNanoTime = bestInitialNanoTime;
        this.isWithinThreshold = false;
    }

    @Override
    public long nanoTime() {
        long nanoTimeAdjustment = System.nanoTime() - this.initialNanoTime;
        if (nanoTimeAdjustment < 0L || nanoTimeAdjustment > this.resampleIntervalNs) {
            this.sample();
            return this.nanoTime();
        }
        return this.initialCurrentNanoTime + nanoTimeAdjustment;
    }

    public boolean isWithinThreshold() {
        return this.isWithinThreshold;
    }
}

