/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.util.DefaultAddressPortMapper;
import com.xebialabs.overthere.util.OverthereUtils;

public abstract class ConnectionValidator {
    public static void checkIsWindowsHost(OperatingSystemFamily os, String protocol, CifsConnectionType connectionType) {
        OverthereUtils.checkArgument(os == OperatingSystemFamily.WINDOWS, "Cannot create a " + protocol + ":%s connection to a host that is not running Windows", connectionType.toString().toLowerCase());
    }

    public static void checkNotNewStyleWindowsDomain(String username, String protocol, CifsConnectionType connectionType) {
        OverthereUtils.checkArgument(!username.contains("@"), "Cannot create a " + protocol + ":%s connection with a new-style Windows domain account [%s], use DOMAIN\\USER instead.", connectionType.toString().toLowerCase(), username);
    }

    public static void checkNotOldStyleWindowsDomain(String username, String protocol, CifsConnectionType connectionType) {
        OverthereUtils.checkArgument(!username.contains("\\"), "Cannot create a " + protocol + ":%s connection with an old-style Windows domain account [%s], use USER@DOMAIN instead.", connectionType.toString().toLowerCase(), username);
    }

    public static void checkNotThroughJumpstation(AddressPortMapper mapper, String protocol, CifsConnectionType connectionType) {
        OverthereUtils.checkArgument(mapper instanceof DefaultAddressPortMapper, "Cannot create a " + protocol + ":%s connection when connecting through a SSH jumpstation", connectionType.toString().toLowerCase());
    }

    public static void checkNoSingleQuoteInPassword(String password, String protocol, CifsConnectionType connectionType) {
        OverthereUtils.checkArgument(password.indexOf(39) == -1 && password.indexOf(34) == -1, "Cannot create a " + protocol + ":%s connection with a password that contains a single quote (') or a double quote (\")", connectionType.toString().toLowerCase());
    }
}

