/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.model;

import akka.http.scaladsl.model.DateTime;
import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple9;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DateTime$
implements Serializable {
    public static final DateTime$ MODULE$ = new DateTime$();
    private static final String[] WEEKDAYS = (String[])((Object[])new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"});
    private static final String[] MONTHS = (String[])((Object[])new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"});
    private static final DateTime MinValue = MODULE$.apply(1800, 1, 1, MODULE$.apply$default$4(), MODULE$.apply$default$5(), MODULE$.apply$default$6());
    private static final DateTime MaxValue = MODULE$.apply(2199, 12, 31, 23, 59, 59);

    public String weekday(int index) {
        return WEEKDAYS[index];
    }

    public String month(int index) {
        return MONTHS[index];
    }

    public DateTime MinValue() {
        return MinValue;
    }

    public DateTime MaxValue() {
        return MaxValue;
    }

    public DateTime apply(int year, int month, int day, int hour, int minute, int second) {
        Predef$.MODULE$.require(1800 <= year && year <= 9999, (Function0 & Serializable)() -> "year must be >= 1800 and <= 9999");
        Predef$.MODULE$.require(1 <= month && month <= 12, (Function0 & Serializable)() -> "month must be >= 1 and <= 12");
        Predef$.MODULE$.require(1 <= day && day <= 31, (Function0 & Serializable)() -> "day must be >= 1 and <= 31");
        Predef$.MODULE$.require(0 <= hour && hour <= 23, (Function0 & Serializable)() -> "hour must be >= 0 and <= 23");
        Predef$.MODULE$.require(0 <= minute && minute <= 59, (Function0 & Serializable)() -> "minute_ must be >= 0 and <= 59");
        Predef$.MODULE$.require(0 <= second && second <= 59, (Function0 & Serializable)() -> "second must be >= 0 and <= 59");
        int m = month - 1;
        int m7 = m % 7;
        int d = m7 * 30 + (m7 + 1 >> 1) + day;
        boolean isLeap = this.isLeapYear(year);
        if (m >= 7) {
            d += 214;
        }
        if (d >= 61) {
            --d;
        }
        if (!isLeap && d >= 60) {
            --d;
        }
        int y = year - 1;
        int yd = y / 100;
        int dn = (d += y * 365 + (y >> 2) - yd + (yd >> 2)) - 719162;
        long c = (long)(dn - 1) * 86400L + (long)hour * 3600L + (long)minute * 60L + (long)second;
        return new DateTime(year, month, day, hour, minute, second, d % 7, c * 1000L, isLeap);
    }

    public DateTime apply(long clicks) {
        long c;
        Predef$.MODULE$.require(this.MinValue().clicks() <= clicks && clicks <= this.MaxValue().clicks(), (Function0 & Serializable)() -> new StringBuilder(34).append("DateTime value must be >= ").append(MODULE$.MinValue()).append(" and <= ").append(MODULE$.MaxValue()).toString());
        long s2 = c = clicks - clicks % 1000L;
        s2 = s2 >= 0L ? (s2 /= 1000L) : (s2 - 999L) / 1000L;
        int dn = (int)(s2 / 86400L);
        if ((s2 %= 86400L) < 0L) {
            s2 += 86400L;
            --dn;
        }
        int y = 400 * ((dn += 719162) / 146097) + 1;
        int d = dn % 146097;
        if (d == 146096) {
            y += 399;
            d = 365;
        } else {
            y += 100 * (d / 36524);
            y += (d %= 36524) / 1461 << 2;
            if ((d %= 1461) == 1460) {
                y += 3;
                d = 365;
            } else {
                y += d / 365;
                d %= 365;
            }
        }
        boolean isLeap = this.isLeapYear(y);
        if (!isLeap && d >= 59) {
            ++d;
        }
        if (d >= 60) {
            ++d;
        }
        int d214 = d % 214;
        int d214_61 = d214 % 61;
        int mon = (d214 / 61 << 1) + d214_61 / 31;
        if (d > 213) {
            mon += 7;
        }
        d = d214_61 % 31 + 1;
        int m = (int)(s2 / 60L);
        int h = m / 60;
        int w = (dn + 1) % 7;
        return new DateTime(y, mon + 1, d, h, m %= 60, (int)(s2 %= 60L), w, c, isLeap);
    }

    public int apply$default$4() {
        return 0;
    }

    public int apply$default$5() {
        return 0;
    }

    public int apply$default$6() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isLeapYear(int year) {
        if ((year & 3) != 0) return false;
        int q = year / 100;
        int r = year % 100;
        if (r != 0) return true;
        if ((q & 3) != 0) return false;
        return true;
    }

    public DateTime now() {
        return this.apply(System.currentTimeMillis());
    }

    public Option<DateTime> fromIsoDateTimeString(String string) {
        None$ none$;
        if (DateTime$.check$1(string.length(), string)) {
            try {
                int year = DateTime$.i$1(0, string) * 1000 + DateTime$.i$1(1, string) * 100 + DateTime$.mul10$1(DateTime$.i$1(2, string)) + DateTime$.i$1(3, string);
                int month = DateTime$.mul10$1(DateTime$.i$1(5, string)) + DateTime$.i$1(6, string);
                int day = DateTime$.mul10$1(DateTime$.i$1(8, string)) + DateTime$.i$1(9, string);
                int hour = DateTime$.mul10$1(DateTime$.i$1(11, string)) + DateTime$.i$1(12, string);
                int min2 = DateTime$.mul10$1(DateTime$.i$1(14, string)) + DateTime$.i$1(15, string);
                int sec = DateTime$.mul10$1(DateTime$.i$1(17, string)) + DateTime$.i$1(18, string);
                none$ = new Some((Object)this.apply(year, month, day, hour, min2, sec));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public DateTime apply(int year, int month, int day, int hour, int minute, int second, int weekday, long clicks, boolean isLeapYear) {
        return new DateTime(year, month, day, hour, minute, second, weekday, clicks, isLeapYear);
    }

    public Option<Tuple9<Object, Object, Object, Object, Object, Object, Object, Object, Object>> unapply(DateTime x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple9((Object)BoxesRunTime.boxToInteger((int)x$0.year()), (Object)BoxesRunTime.boxToInteger((int)x$0.month()), (Object)BoxesRunTime.boxToInteger((int)x$0.day()), (Object)BoxesRunTime.boxToInteger((int)x$0.hour()), (Object)BoxesRunTime.boxToInteger((int)x$0.minute()), (Object)BoxesRunTime.boxToInteger((int)x$0.second()), (Object)BoxesRunTime.boxToInteger((int)x$0.weekday()), (Object)BoxesRunTime.boxToLong((long)x$0.clicks()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isLeapYear())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DateTime$.class);
    }

    private static final char c$1(int ix, String string$1) {
        return string$1.charAt(ix);
    }

    private static final boolean isDigit$1(char c) {
        return '0' <= c && c <= '9';
    }

    private static final int i$1(int ix, String string$1) {
        char x = DateTime$.c$1(ix, string$1);
        Predef$.MODULE$.require(DateTime$.isDigit$1(x));
        return x - 48;
    }

    private static final boolean check$1(int len, String string$1) {
        boolean bl;
        int n = len;
        switch (n) {
            case 19: {
                if (DateTime$.c$1(4, string$1) == '-' && DateTime$.c$1(7, string$1) == '-' && DateTime$.c$1(10, string$1) == 'T' && DateTime$.c$1(13, string$1) == ':' && DateTime$.c$1(16, string$1) == ':') {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 24: {
                if (DateTime$.check$1(19, string$1) && DateTime$.c$1(19, string$1) == '.' && DateTime$.isDigit$1(DateTime$.c$1(20, string$1)) && DateTime$.isDigit$1(DateTime$.c$1(21, string$1)) && DateTime$.isDigit$1(DateTime$.c$1(22, string$1)) && DateTime$.c$1(23, string$1) == 'Z') {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
                break;
            }
        }
        return bl;
    }

    private static final int mul10$1(int i) {
        return (i << 3) + (i << 1);
    }

    private DateTime$() {
    }
}

