/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.locks;

import com.ibm.asyncutil.locks.AsyncEpoch;
import com.ibm.asyncutil.util.StageSupport;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class StripedEpoch
implements AsyncEpoch,
AsyncEpoch.EpochToken {
    private static final long TERMINATED = 1L;
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final EpochCell[] DEAD_CELLS = new EpochCell[0];
    private static final AtomicLongFieldUpdater<StripedEpoch> baseUpdater = AtomicLongFieldUpdater.newUpdater(StripedEpoch.class, "baseEntrants");
    private static final AtomicReferenceFieldUpdater<StripedEpoch, EpochCell[]> cellArrayUpdater = AtomicReferenceFieldUpdater.newUpdater(StripedEpoch.class, EpochCell[].class, "cells");
    private volatile long baseEntrants;
    private volatile EpochCell[] cells;
    private final CountdownFuture terminateFuture = new CountdownFuture();
    private static final AtomicLongFieldUpdater<Value> cellUpdater = AtomicLongFieldUpdater.newUpdater(Value.class, "entrants");
    private static ThreadLocal<int[]> probe = ThreadLocal.withInitial(() -> {
        int next = ThreadLocalRandom.current().nextInt();
        return new int[]{next == 0 ? 1 : next};
    });

    StripedEpoch() {
    }

    @Override
    public Optional<AsyncEpoch.EpochToken> enter() {
        EpochCell[] localCells = this.cells;
        if (localCells == null) {
            UpdateResult er = StripedEpoch.tryUpdate(baseUpdater, this, 2);
            if (er == UpdateResult.SUCCESS) {
                return Optional.of(this);
            }
            if (er == UpdateResult.CLOSED) {
                return Optional.empty();
            }
            localCells = this.growCells(null);
        }
        assert (localCells != null);
        return this.enterContended(localCells);
    }

    private Optional<AsyncEpoch.EpochToken> enterContended(EpochCell[] localCells) {
        int threadIndex = StripedEpoch.getProbe();
        while (localCells != DEAD_CELLS) {
            EpochCell myCell = localCells[threadIndex & localCells.length - 1];
            UpdateResult er = StripedEpoch.tryUpdate(cellUpdater, myCell, 2);
            if (er == UpdateResult.SUCCESS) {
                return Optional.of(this);
            }
            if (er == UpdateResult.CLOSED) {
                return Optional.empty();
            }
            if (er != UpdateResult.CONFLICT) continue;
            if (localCells.length < NCPU) {
                localCells = this.growCells(localCells);
                continue;
            }
            threadIndex = StripedEpoch.advanceProbe(threadIndex);
        }
        return Optional.empty();
    }

    @Override
    public void close() {
        EpochCell[] localCells = this.cells;
        if (localCells == null) {
            UpdateResult er = StripedEpoch.tryUpdate(baseUpdater, this, -2);
            if (er == UpdateResult.SUCCESS) {
                return;
            }
            if (er == UpdateResult.CLOSED) {
                this.terminateFuture.countdown();
                return;
            }
            localCells = this.growCells(null);
        }
        assert (localCells != null);
        this.departContended(localCells);
    }

    private void departContended(EpochCell[] localCells) {
        UpdateResult er;
        int threadIndex = StripedEpoch.getProbe();
        while (true) {
            if (localCells == DEAD_CELLS) {
                this.terminateFuture.countdown();
                return;
            }
            EpochCell myCell = localCells[threadIndex & localCells.length - 1];
            er = StripedEpoch.tryUpdate(cellUpdater, myCell, -2);
            if (er != UpdateResult.CONFLICT) break;
            if (localCells.length < NCPU) {
                localCells = this.growCells(localCells);
                continue;
            }
            threadIndex = StripedEpoch.advanceProbe(threadIndex);
        }
        if (er == UpdateResult.CLOSED) {
            this.terminateFuture.countdown();
        }
    }

    private EpochCell[] growCells(EpochCell[] old) {
        EpochCell[] newCells;
        if (old == null) {
            newCells = new EpochCell[]{new EpochCell(), new EpochCell()};
        } else {
            newCells = new EpochCell[old.length << 1];
            System.arraycopy(old, 0, newCells, 0, old.length);
            for (int i = old.length; i < newCells.length; ++i) {
                newCells[i] = new EpochCell();
            }
        }
        if (cellArrayUpdater.compareAndSet(this, old, newCells)) {
            return newCells;
        }
        return this.cells;
    }

    @Override
    public CompletionStage<Boolean> terminate() {
        EpochCell[] localCells = cellArrayUpdater.getAndSet(this, DEAD_CELLS);
        if (localCells == DEAD_CELLS) {
            return this.terminateFuture.thenApply(ig -> false);
        }
        long entrantCount = StripedEpoch.terminateCounter(baseUpdater, this);
        if (localCells != null) {
            for (int i = 0; i < localCells.length; ++i) {
                entrantCount += StripedEpoch.terminateCounter(cellUpdater, localCells[i]);
            }
        }
        this.terminateFuture.initialize(entrantCount);
        return this.terminateFuture;
    }

    @Override
    public boolean isTerminated() {
        long localBase = this.baseEntrants;
        if ((localBase & 1L) == 0L) {
            return false;
        }
        EpochCell[] localCells = this.cells;
        if (localCells != null) {
            for (EpochCell cell : localCells) {
                long entrants = cell.entrants;
                if ((entrants & 1L) != 0L) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public CompletionStage<Void> awaitCompletion() {
        return StageSupport.voided(this.terminateFuture);
    }

    private static <T> UpdateResult tryUpdate(AtomicLongFieldUpdater<T> updater, T obj, int delta) {
        assert (((long)delta & 1L) == 0L) : "increment/decrement shouldn't set terminate bit";
        long curr = updater.get(obj);
        if ((curr & 1L) != 0L) {
            return UpdateResult.CLOSED;
        }
        long newVal = curr + (long)delta;
        if ((newVal & 1L) != 0L) {
            throw new IllegalStateException("excessively used epoch");
        }
        if (updater.compareAndSet(obj, curr, curr + (long)delta)) {
            return UpdateResult.SUCCESS;
        }
        return UpdateResult.CONFLICT;
    }

    private static <T> long terminateCounter(AtomicLongFieldUpdater<T> updater, T obj) {
        long oldVal = updater.getAndAdd(obj, 1L);
        if ((oldVal & 1L) != 0L) {
            throw new IllegalStateException("counter already terminated (should be impossible)");
        }
        return StripedEpoch.decode(oldVal);
    }

    private static long decode(long count) {
        return count >> 1;
    }

    private static int getProbe() {
        return probe.get()[0];
    }

    private static int advanceProbe(int h) {
        h ^= h << 13;
        h ^= h >>> 17;
        h ^= h << 5;
        StripedEpoch.probe.get()[0] = h;
        return h;
    }

    private static class CountdownFuture
    extends CompletableFuture<Boolean> {
        volatile long count;
        static final AtomicLongFieldUpdater<CountdownFuture> countUpdater = AtomicLongFieldUpdater.newUpdater(CountdownFuture.class, "count");

        private CountdownFuture() {
        }

        void initialize(long n) {
            if (n < 0L) {
                throw new IllegalStateException("entrants can't be negative");
            }
            if (this.count > 0L) {
                throw new IllegalStateException("CountdownFuture initialized twice");
            }
            long updated = countUpdater.addAndGet(this, n);
            if (updated < 0L) {
                throw new IllegalStateException("Excessively closed epoch");
            }
            if (updated == 0L) {
                boolean completed = this.complete(true);
                assert (completed);
            }
        }

        void countdown() {
            long curr = countUpdater.decrementAndGet(this);
            if (curr == 0L) {
                boolean completed = this.complete(true);
                assert (completed);
            }
        }
    }

    private static class EpochCell
    extends RightPad {
        private EpochCell() {
        }
    }

    private static class RightPad
    extends Value {
        protected volatile long r0;
        protected volatile long r1;
        protected volatile long r2;
        protected volatile long r3;
        protected volatile long r4;
        protected volatile long r5;
        protected volatile long r6;
        protected volatile long r7;
        protected volatile long r8;
        protected volatile long r9;
        protected volatile long r10;
        protected volatile long r11;
        protected volatile long r12;
        protected volatile long r13;
        protected volatile long r14;
        protected volatile long r15;

        private RightPad() {
        }
    }

    private static class Value
    extends LeftPad {
        protected volatile long entrants;

        private Value() {
        }
    }

    private static class LeftPad {
        protected volatile long l0;
        protected volatile long l1;
        protected volatile long l2;
        protected volatile long l3;
        protected volatile long l4;
        protected volatile long l5;
        protected volatile long l6;
        protected volatile long l7;
        protected volatile long l8;
        protected volatile long l9;
        protected volatile long l10;
        protected volatile long l11;
        protected volatile long l12;
        protected volatile long l13;
        protected volatile long l14;
        protected volatile long l15;

        private LeftPad() {
        }
    }

    static enum UpdateResult {
        SUCCESS,
        CONFLICT,
        CLOSED;

    }
}

