/*******************************************************************************
 * Copyright  2015 rzorzorzo@users.sf.net
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package org.rzo.yajsw.controller.jvm;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

import org.rzo.yajsw.controller.Message;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;

public class MessageEncoder extends MessageToByteEncoder<Message>
{

	/** The Constant encoder. */
	static final CharsetEncoder encoder = Charset.defaultCharset().newEncoder();

	@Override
	protected void encode(ChannelHandlerContext ctx, Message m, ByteBuf buffer)
			throws Exception
	{
		buffer.writeByte(m.getCode());
		buffer.writeBytes(encoder.encode(CharBuffer.wrap(m.getMessage())));
		buffer.writeByte((byte) 0);
	}

}
