/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.statement;

import java.sql.Connection;
import java.sql.SQLException;
import org.dbunit.database.statement.AbstractPreparedBatchStatement;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePreparedStatement
extends AbstractPreparedBatchStatement {
    private static final Logger logger = LoggerFactory.getLogger(SimplePreparedStatement.class);
    private int _index = 0;
    private int _result = 0;

    public SimplePreparedStatement(String sql, Connection connection) throws SQLException {
        super(sql, connection);
    }

    @Override
    public void addValue(Object value, DataType dataType) throws TypeCastException, SQLException {
        logger.debug("addValue(value={}, dataType={}) - start", value, (Object)dataType);
        if (value == null || value == ITable.NO_VALUE) {
            String sqlTypeName = dataType.getSqlTypeName();
            if (sqlTypeName == null) {
                this._statement.setNull(++this._index, dataType.getSqlType());
            } else {
                this._statement.setNull(++this._index, dataType.getSqlType(), sqlTypeName);
            }
            return;
        }
        dataType.setSqlValue(value, ++this._index, this._statement);
    }

    @Override
    public void addBatch() throws SQLException {
        logger.debug("addBatch() - start");
        boolean result = this._statement.execute();
        if (!result) {
            this._result += this._statement.getUpdateCount();
        }
        this._index = 0;
    }

    @Override
    public int executeBatch() throws SQLException {
        logger.debug("executeBatch() - start");
        int result = this._result;
        this.clearBatch();
        return result;
    }

    @Override
    public void clearBatch() throws SQLException {
        logger.debug("clearBatch() - start");
        this._index = 0;
        this._result = 0;
    }
}

