/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.focus;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.gui.form.FormContainerComponent;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.StandardComponent;
import com.jeta.forms.store.memento.CompositeFocusKey;
import com.jeta.forms.store.memento.ContainerFocusKey;
import com.jeta.forms.store.memento.FocusKey;
import com.jeta.forms.store.memento.FocusPolicyMemento;
import com.jeta.forms.store.memento.FormCellFocusKey;
import com.jeta.open.support.EmptyCollection;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutFocusTraversalPolicy;

public class FormFocusManager {
    private FormComponent m_form;
    private ArrayList m_focus_list;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FormFocusManager(FormComponent formComponent) {
        Serializable serializable;
        this.disableChildFocusCycleRoots(formComponent);
        formComponent.setFocusCycleRoot(true);
        this.m_form = formComponent;
        ArrayList arrayList = this.buildStoredFocusList(formComponent);
        LinkedHashSet linkedHashSet = FormFocusManager.buildDefaultFocusPolicy(formComponent);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            serializable = (Component)iterator.next();
            if (linkedHashSet.contains(serializable)) continue;
            iterator.remove();
        }
        serializable = new HashSet();
        ((AbstractCollection)((Object)serializable)).addAll(arrayList);
        Component component = null;
        iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Component component2 = (Component)iterator.next();
            if (!((HashSet)serializable).contains(component2)) {
                ((HashSet)serializable).add(component2);
                if (component == null) {
                    arrayList.add(0, component2);
                } else {
                    int n = arrayList.indexOf(component);
                    if (!$assertionsDisabled && n < 0) {
                        throw new AssertionError();
                    }
                    if (n >= 0) {
                        arrayList.add(n + 1, component2);
                    }
                }
            }
            component = component2;
        }
        this.m_focus_list = arrayList;
    }

    public FormFocusManager(FormComponent formComponent, Collection collection) {
        this.m_form = formComponent;
        this.m_focus_list = new ArrayList(collection);
    }

    public static LinkedHashSet buildDefaultFocusPolicy(FormComponent formComponent) {
        System.out.println("buildDefaultFocusPolicy  form: " + formComponent.getId());
        final FormComponent formComponent2 = formComponent;
        LinkedHashSet<Component> linkedHashSet = new LinkedHashSet<Component>();
        LayoutFocusTraversalPolicy layoutFocusTraversalPolicy = new LayoutFocusTraversalPolicy(){

            protected boolean accept(Component component) {
                if (component instanceof StandardComponent && ((StandardComponent)component).getBeanDelegate() == null) {
                    return false;
                }
                if (component == formComponent2) {
                    return super.accept(component);
                }
                if (component instanceof FormComponent && ((FormComponent)component).isTopLevelForm()) {
                    return false;
                }
                if (component instanceof JTabbedPane) {
                    return true;
                }
                if (component != null) {
                    for (Container container = component.getParent(); container != null && container != formComponent2; container = container.getParent()) {
                        if (!(container instanceof FormContainerComponent)) continue;
                        return false;
                    }
                }
                return super.accept(component);
            }
        };
        Component component = layoutFocusTraversalPolicy.getFirstComponent(formComponent);
        Component component2 = layoutFocusTraversalPolicy.getLastComponent(formComponent);
        while (true) {
            if (FormUtils.isDesignMode()) {
                if (!(component instanceof JScrollPane) && !(component instanceof JScrollBar)) {
                    linkedHashSet.add(component);
                }
            } else {
                linkedHashSet.add(component);
            }
            if (component == component2) break;
            System.out.println("FormFocusManager.getComponentAfter: " + component.getClass());
            component = layoutFocusTraversalPolicy.getComponentAfter(formComponent, component);
        }
        return linkedHashSet;
    }

    ArrayList buildStoredFocusList(FormComponent formComponent) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        FocusPolicyMemento focusPolicyMemento = formComponent.getFocusPolicy();
        if (focusPolicyMemento != null) {
            Collection collection = focusPolicyMemento.getFocusPolicyKeys();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                FocusKey focusKey = (FocusKey)iterator.next();
                Component component = focusKey.getComponent(formComponent);
                if (component == null) continue;
                arrayList.add(component);
            }
        }
        return arrayList;
    }

    public void buildFocusKeys(HashSet hashSet, HashMap hashMap, FormComponent formComponent, CompositeFocusKey compositeFocusKey) {
        for (int i = 1; i <= formComponent.getRowCount(); ++i) {
            for (int j = 1; j <= formComponent.getColumnCount(); ++j) {
                CompositeFocusKey compositeFocusKey2;
                Component component;
                GridComponent gridComponent = formComponent.getGridComponent(j, i);
                if (gridComponent instanceof StandardComponent) {
                    component = gridComponent.getBeanDelegate();
                    if (component == null) continue;
                    if (hashSet.contains(component)) {
                        compositeFocusKey2 = (CompositeFocusKey)compositeFocusKey.clone();
                        compositeFocusKey2.add(new FormCellFocusKey(i, j, component));
                        hashMap.put(component, compositeFocusKey2);
                        continue;
                    }
                    if (!(component instanceof Container)) continue;
                    compositeFocusKey2 = (CompositeFocusKey)compositeFocusKey.clone();
                    compositeFocusKey2.add(new FormCellFocusKey(i, j, component));
                    this.buildContainerFocusKeys(hashSet, hashMap, (Container)component, compositeFocusKey2);
                    continue;
                }
                if (gridComponent instanceof FormComponent) {
                    component = (FormComponent)gridComponent;
                    compositeFocusKey2 = (CompositeFocusKey)compositeFocusKey.clone();
                    compositeFocusKey2.add(new FormCellFocusKey(i, j, gridComponent));
                    this.buildFocusKeys(hashSet, hashMap, (FormComponent)component, compositeFocusKey2);
                    continue;
                }
                if (gridComponent == null) continue;
                System.out.println("FormFocusManager.buildDefaultPolicyFailed  found unknown comp: " + gridComponent.getClass());
            }
        }
    }

    public void buildContainerFocusKeys(HashSet hashSet, HashMap hashMap, Container container, CompositeFocusKey compositeFocusKey) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            CompositeFocusKey compositeFocusKey2;
            Component component = container.getComponent(i);
            if (hashSet.contains(component)) {
                compositeFocusKey2 = (CompositeFocusKey)compositeFocusKey.clone();
                compositeFocusKey2.add(new ContainerFocusKey(i, component));
                hashMap.put(component, compositeFocusKey2);
                continue;
            }
            if (!(component instanceof Container)) continue;
            compositeFocusKey2 = (CompositeFocusKey)compositeFocusKey.clone();
            compositeFocusKey2.add(new ContainerFocusKey(i, component));
            this.buildContainerFocusKeys(hashSet, hashMap, (Container)component, compositeFocusKey2);
        }
    }

    public boolean contains(Component component) {
        return this.m_focus_list.contains(component);
    }

    private void disableChildFocusCycleRoots(Container container) {
        if (container == null) {
            return;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof StandardComponent || component instanceof FormPanel) {
                ((Container)component).setFocusCycleRoot(false);
                this.disableChildFocusCycleRoots((Container)component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.disableChildFocusCycleRoots((Container)component);
        }
    }

    public FocusPolicyMemento getFocusPolicyMemento() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.m_focus_list);
        HashMap hashMap = new HashMap();
        CompositeFocusKey compositeFocusKey = new CompositeFocusKey();
        this.buildFocusKeys(hashSet, hashMap, this.m_form, compositeFocusKey);
        FocusPolicyMemento focusPolicyMemento = new FocusPolicyMemento();
        Iterator iterator = this.m_focus_list.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            FocusKey focusKey = (FocusKey)hashMap.get(component);
            if (focusKey == null) continue;
            focusPolicyMemento.addFocusKey(focusKey);
        }
        return focusPolicyMemento;
    }

    public Component getComponent(int n) {
        if (n < 0 || n >= this.m_focus_list.size()) {
            return null;
        }
        return (Component)this.m_focus_list.get(n);
    }

    public int getComponentCount() {
        return this.m_focus_list.size();
    }

    public Collection getFocusList() {
        if (this.m_focus_list == null) {
            return EmptyCollection.getInstance();
        }
        return this.m_focus_list;
    }

    public void validateFocusKeys(FormComponent formComponent, FocusPolicyMemento focusPolicyMemento) {
        Iterator iterator = focusPolicyMemento.getFocusPolicyKeys().iterator();
        while (iterator.hasNext()) {
            FocusKey focusKey = (FocusKey)iterator.next();
            Component component = focusKey.getComponent(formComponent);
            if (!$assertionsDisabled && component == null) {
                throw new AssertionError();
            }
            System.out.print("Focuskey validated: ");
            focusKey.print();
            System.out.println("   comp: " + component.getClass());
        }
    }

    static {
        $assertionsDisabled = !FormFocusManager.class.desiredAssertionStatus();
    }
}

