/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.authentication;

import java.util.Locale;
import org.springframework.ldap.BadLdapGrammarException;

final class LdapEncoder {
    private static final int HEX = 16;
    private static String[] NAME_ESCAPE_TABLE;
    private static String[] FILTER_ESCAPE_TABLE;

    private LdapEncoder() {
    }

    protected static String toTwoCharHex(char c) {
        String raw = Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
        return raw.length() > 1 ? raw : "0" + raw;
    }

    static String filterEncode(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder encodedValue = new StringBuilder(value.length() * 2);
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            encodedValue.append(ch < FILTER_ESCAPE_TABLE.length ? FILTER_ESCAPE_TABLE[ch] : Character.valueOf(ch));
        }
        return encodedValue.toString();
    }

    static String nameEncode(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder encodedValue = new StringBuilder(value.length() * 2);
        int length = value.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            String esc;
            char c = value.charAt(i);
            if (c == ' ' && (i == 0 || i == last)) {
                encodedValue.append("\\ ");
                continue;
            }
            if (c < NAME_ESCAPE_TABLE.length && (esc = NAME_ESCAPE_TABLE[c]) != null) {
                encodedValue.append(esc);
                continue;
            }
            encodedValue.append(c);
        }
        return encodedValue.toString();
    }

    static String nameDecode(String value) throws BadLdapGrammarException {
        if (value == null) {
            return null;
        }
        StringBuilder decoded = new StringBuilder(value.length());
        int i = 0;
        while (i < value.length()) {
            char currentChar = value.charAt(i);
            if (currentChar == '\\') {
                if (value.length() <= i + 1) {
                    throw new BadLdapGrammarException("Unexpected end of value unterminated '\\'");
                }
                char nextChar = value.charAt(i + 1);
                if (LdapEncoder.isNormalBackslashEscape(nextChar)) {
                    decoded.append(nextChar);
                    i += 2;
                    continue;
                }
                if (value.length() <= i + 2) {
                    throw new BadLdapGrammarException("Unexpected end of value expected special or hex, found '" + nextChar + "'");
                }
                String hexString = "" + nextChar + value.charAt(i + 2);
                decoded.append((char)Integer.parseInt(hexString, 16));
                i += 3;
                continue;
            }
            decoded.append(currentChar);
            ++i;
        }
        return decoded.toString();
    }

    private static boolean isNormalBackslashEscape(char nextChar) {
        return nextChar == ',' || nextChar == '=' || nextChar == '+' || nextChar == '<' || nextChar == '>' || nextChar == '#' || nextChar == ';' || nextChar == '\\' || nextChar == '\"' || nextChar == ' ';
    }

    static {
        char c;
        NAME_ESCAPE_TABLE = new String[96];
        for (c = '\u0000'; c < ' '; c = (char)(c + '\u0001')) {
            LdapEncoder.NAME_ESCAPE_TABLE[c] = "\\" + LdapEncoder.toTwoCharHex(c);
        }
        LdapEncoder.NAME_ESCAPE_TABLE[35] = "\\#";
        LdapEncoder.NAME_ESCAPE_TABLE[44] = "\\,";
        LdapEncoder.NAME_ESCAPE_TABLE[59] = "\\;";
        LdapEncoder.NAME_ESCAPE_TABLE[61] = "\\=";
        LdapEncoder.NAME_ESCAPE_TABLE[43] = "\\+";
        LdapEncoder.NAME_ESCAPE_TABLE[60] = "\\<";
        LdapEncoder.NAME_ESCAPE_TABLE[62] = "\\>";
        LdapEncoder.NAME_ESCAPE_TABLE[34] = "\\\"";
        LdapEncoder.NAME_ESCAPE_TABLE[92] = "\\\\";
        FILTER_ESCAPE_TABLE = new String[93];
        for (c = '\u0000'; c < FILTER_ESCAPE_TABLE.length; c = (char)(c + '\u0001')) {
            LdapEncoder.FILTER_ESCAPE_TABLE[c] = String.valueOf(c);
        }
        LdapEncoder.FILTER_ESCAPE_TABLE[42] = "\\2a";
        LdapEncoder.FILTER_ESCAPE_TABLE[40] = "\\28";
        LdapEncoder.FILTER_ESCAPE_TABLE[41] = "\\29";
        LdapEncoder.FILTER_ESCAPE_TABLE[92] = "\\5c";
        LdapEncoder.FILTER_ESCAPE_TABLE[0] = "\\00";
    }
}

