/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.time.Duration;
import java.util.function.Supplier;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoderInitializationException;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class SupplierReactiveJwtDecoder
implements ReactiveJwtDecoder {
    private static final Duration FOREVER = Duration.ofMillis(Long.MAX_VALUE);
    private Mono<ReactiveJwtDecoder> jwtDecoderMono;

    public SupplierReactiveJwtDecoder(Supplier<ReactiveJwtDecoder> supplier) {
        this.jwtDecoderMono = Mono.fromSupplier(supplier).subscribeOn(Schedulers.boundedElastic()).publishOn(Schedulers.parallel()).onErrorMap(this::wrapException).cache(delegate -> FOREVER, ex -> Duration.ZERO, () -> Duration.ZERO);
    }

    private JwtDecoderInitializationException wrapException(Throwable t) {
        return new JwtDecoderInitializationException("Failed to lazily resolve the supplied JwtDecoder instance", t);
    }

    @Override
    public Mono<Jwt> decode(String token) throws JwtException {
        return this.jwtDecoderMono.flatMap(decoder -> decoder.decode(token));
    }
}

