/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.dto;

import com.xebialabs.deployit.core.api.dto.AbstractDTO;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@XmlRootElement
public class Comparison
extends AbstractDTO {
    private List<ComparisonLine> lines = new ArrayList<ComparisonLine>();

    public static Comparison from(Map<String, List<String>> multimap) {
        Comparison c = new Comparison();
        for (String key : multimap.keySet()) {
            List<String> values = multimap.get(key);
            c.addLine(key, values);
        }
        return c;
    }

    private void addLine(String key, List<String> values) {
        this.lines.add(new ComparisonLine(key, values.get(0), values.subList(1, values.size())));
    }

    @XmlElement
    public List<ComparisonLine> getLines() {
        return this.lines;
    }

    public void setLines(List<ComparisonLine> lines) {
        this.lines = lines;
    }

    public static class ComparisonLine
    extends AbstractDTO {
        private String key;
        private String referenceValue;
        private List<String> values;

        public ComparisonLine() {
        }

        public ComparisonLine(String key, String referenceValue, List<String> values) {
            this.key = key;
            this.referenceValue = referenceValue;
            this.values = values;
        }

        @XmlElement
        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @XmlElement
        public String getReferenceValue() {
            return this.referenceValue;
        }

        public void setReferenceValue(String referenceValue) {
            this.referenceValue = referenceValue;
        }

        @XmlElement
        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }
    }
}

