/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.ws;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.ws.FrameEvent$;
import org.apache.pekko.http.impl.engine.ws.FrameStart;
import org.apache.pekko.http.impl.engine.ws.Protocol;
import org.apache.pekko.http.impl.engine.ws.Protocol$Opcode$Binary$;
import org.apache.pekko.http.impl.engine.ws.Protocol$Opcode$Continuation$;
import org.apache.pekko.http.impl.engine.ws.Protocol$Opcode$Text$;
import org.apache.pekko.http.impl.engine.ws.Utf8Encoder$;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.scaladsl.model.ws.BinaryMessage;
import org.apache.pekko.http.scaladsl.model.ws.Message;
import org.apache.pekko.http.scaladsl.model.ws.TextMessage;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.runtime.BooleanRef;

@InternalApi
public final class MessageToFrameRenderer$ {
    public static final MessageToFrameRenderer$ MODULE$ = new MessageToFrameRenderer$();

    public Flow<Message, FrameStart, NotUsed> create(boolean serverSide) {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)x0$1 -> {
            Message message = x0$1;
            if (message instanceof BinaryMessage.Strict) {
                BinaryMessage.Strict strict = (BinaryMessage.Strict)message;
                ByteString data = strict.data();
                return MessageToFrameRenderer$.strictFrames$1(Protocol$Opcode$Binary$.MODULE$, data);
            }
            if (message instanceof BinaryMessage) {
                BinaryMessage binaryMessage = (BinaryMessage)message;
                return MessageToFrameRenderer$.streamedFrames$1(Protocol$Opcode$Binary$.MODULE$, binaryMessage.dataStream());
            }
            if (message instanceof TextMessage.Strict) {
                TextMessage.Strict strict = (TextMessage.Strict)message;
                String text = strict.text();
                return MessageToFrameRenderer$.strictFrames$1(Protocol$Opcode$Text$.MODULE$, ByteString$.MODULE$.apply(text, "UTF-8"));
            }
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                return MessageToFrameRenderer$.streamedFrames$1(Protocol$Opcode$Text$.MODULE$, textMessage.textStream().via((Graph)Utf8Encoder$.MODULE$));
            }
            throw new MatchError((Object)message);
        });
    }

    private static final Source strictFrames$1(Protocol.Opcode opcode, ByteString data) {
        return Source$.MODULE$.single((Object)FrameEvent$.MODULE$.fullFrame(opcode, (Option<Object>)None$.MODULE$, data, true, FrameEvent$.MODULE$.fullFrame$default$5(), FrameEvent$.MODULE$.fullFrame$default$6(), FrameEvent$.MODULE$.fullFrame$default$7()));
    }

    private static final Source streamedFrames$1(Protocol.Opcode opcode, Source data) {
        return (Source)data.via(StreamUtils$.MODULE$.statefulMap((Function0 & Serializable)() -> {
            BooleanRef isFirst = BooleanRef.create((boolean)true);
            return (Function1 & Serializable)data -> {
                Protocol.Opcode opcode;
                if (isFirst$1.elem) {
                    isFirst$1.elem = false;
                    opcode = opcode;
                } else {
                    opcode = Protocol$Opcode$Continuation$.MODULE$;
                }
                Protocol$Opcode$Continuation$ frameOpcode = opcode;
                return FrameEvent$.MODULE$.fullFrame(frameOpcode, (Option<Object>)None$.MODULE$, (ByteString)data, false, FrameEvent$.MODULE$.fullFrame$default$5(), FrameEvent$.MODULE$.fullFrame$default$6(), FrameEvent$.MODULE$.fullFrame$default$7());
            };
        })).$plus$plus((Graph)Source$.MODULE$.single((Object)FrameEvent$.MODULE$.emptyLastContinuationFrame()));
    }

    private MessageToFrameRenderer$() {
    }
}

