/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.model;

import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.boot.model.Selection;
import org.hibernate.mapping.Selectable;

public class Formula
extends Selection<String> {
    private final String formula;

    public Formula(String formula) {
        super(Selection.SelectionType.FORMULA);
        this.formula = formula;
    }

    @Override
    public String build() {
        return this.formula;
    }

    public static Formula from(Selectable formula) {
        if (!formula.isFormula()) {
            throw new EnversMappingException("Cannot create audit formula mapping from " + formula.getClass().getName());
        }
        return new Formula(formula.getText());
    }
}

