/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import java.util.Map;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.AuditFunction;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;

public class PropertyFunctionAuditExpression
implements AuditCriterion {
    private AuditFunction function;
    private String otherAlias;
    private String otherPropertyName;
    private String op;

    public PropertyFunctionAuditExpression(AuditFunction function, String otherAlias, String otherPropertyName, String op) {
        this.function = function;
        this.otherAlias = otherAlias;
        this.otherPropertyName = otherPropertyName;
        this.op = op;
    }

    @Override
    public void addToQuery(EnversService enversService, AuditReaderImplementor auditReader, Map<String, String> aliasToEntityNameMap, Map<String, String> aliasToComponentPropertyNameMap, String baseAlias, QueryBuilder queryBuilder, Parameters parameters) {
        String effectiveOtherAlias = this.otherAlias == null ? baseAlias : this.otherAlias;
        String otherEntityName = aliasToEntityNameMap.get(effectiveOtherAlias);
        if (enversService.getEntitiesConfigurations().isVersioned(otherEntityName)) {
            String otherPropertyNamePrefix = CriteriaTools.determineComponentPropertyPrefix(enversService, aliasToEntityNameMap, aliasToComponentPropertyNameMap, effectiveOtherAlias);
            CriteriaTools.checkPropertyNotARelation(enversService, otherEntityName, otherPropertyNamePrefix.concat(this.otherPropertyName));
        }
        parameters.addWhereWithFunction(enversService.getConfig(), aliasToEntityNameMap, aliasToComponentPropertyNameMap, this.function, this.op, effectiveOtherAlias, this.otherPropertyName);
    }
}

