/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.strategy.internal;

import org.hibernate.Session;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.synchronization.SessionCacheCleaner;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.strategy.AuditStrategy;

public class DefaultAuditStrategy
implements AuditStrategy {
    private final SessionCacheCleaner sessionCacheCleaner = new SessionCacheCleaner();

    @Override
    public void perform(Session session, String entityName, Configuration configuration, Object id, Object data, Object revision) {
        session.save(configuration.getAuditEntityName(entityName), data);
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, data);
    }

    @Override
    public void performCollectionChange(Session session, String entityName, String propertyName, Configuration configuration, PersistentCollectionChangeData persistentCollectionChangeData, Object revision) {
        session.save(persistentCollectionChangeData.getEntityName(), persistentCollectionChangeData.getData());
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, persistentCollectionChangeData.getData());
    }

    @Override
    public void addEntityAtRevisionRestriction(Configuration configuration, QueryBuilder rootQueryBuilder, Parameters parameters, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData idData, String revisionPropertyPath, String originalIdPropertyName, String alias1, String alias2, boolean inclusive) {
        QueryBuilder maxERevQb = rootQueryBuilder.newSubQueryBuilder(idData.getAuditEntityName(), alias2);
        maxERevQb.addProjection("max", alias2, revisionPropertyPath, false);
        Parameters maxERevQbParameters = maxERevQb.getRootParameters();
        maxERevQbParameters.addWhereWithNamedParam(revisionPropertyPath, inclusive ? "<=" : "<", "revision");
        idData.getOriginalMapper().addIdsEqualToQuery(maxERevQbParameters, alias1 + "." + originalIdPropertyName, alias2 + "." + originalIdPropertyName);
        String subqueryOperator = configuration.getCorrelatedSubqueryOperator();
        parameters.addWhere(revisionProperty, addAlias, subqueryOperator, maxERevQb);
    }

    @Override
    public void addAssociationAtRevisionRestriction(QueryBuilder rootQueryBuilder, Parameters parameters, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData referencingIdData, String versionsMiddleEntityName, String eeOriginalIdPropertyPath, String revisionPropertyPath, String originalIdPropertyName, String alias1, boolean inclusive, MiddleComponentData ... componentDatas) {
        QueryBuilder maxEeRevQb = rootQueryBuilder.newSubQueryBuilder(versionsMiddleEntityName, "ee2__");
        maxEeRevQb.addProjection("max", "ee2__", revisionPropertyPath, false);
        Parameters maxEeRevQbParameters = maxEeRevQb.getRootParameters();
        maxEeRevQbParameters.addWhereWithNamedParam(revisionPropertyPath, inclusive ? "<=" : "<", "revision");
        String ee2OriginalIdPropertyPath = "ee2__." + originalIdPropertyName;
        referencingIdData.getPrefixedMapper().addIdsEqualToQuery(maxEeRevQbParameters, eeOriginalIdPropertyPath, ee2OriginalIdPropertyPath);
        for (MiddleComponentData componentData : componentDatas) {
            componentData.getComponentMapper().addMiddleEqualToQuery(maxEeRevQbParameters, eeOriginalIdPropertyPath, alias1, ee2OriginalIdPropertyPath, "ee2__");
        }
        parameters.addWhere(revisionProperty, addAlias, "=", maxEeRevQb);
    }
}

