/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.windup.util.exception.WindupException;

public class ZipUtil {
    private static final Logger log = Logger.getLogger(ZipUtil.class.getName());
    private static Set<String> supportedExtensions;
    private static final CopyOption[] COPY_OPTIONS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFromClassResource(Class<?> clazz, String resourcePath, File extractToPath) throws IOException {
        File inputFile = File.createTempFile("windup-resource-to-unzip-", ".zip");
        try {
            try (InputStream stream = clazz.getResourceAsStream(resourcePath);){
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)inputFile);
            }
            extractToPath.mkdirs();
            ZipUtil.unzipToFolder(inputFile, extractToPath);
        }
        finally {
            inputFile.delete();
        }
    }

    public static void unzipToFolder(File inputFile, File outputDir) throws IOException {
        if (inputFile == null) {
            throw new IllegalArgumentException("Argument inputFile is null.");
        }
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument outputDir is null.");
        }
        try (ZipFile zipFile = new ZipFile(inputFile);){
            Enumeration<? extends ZipEntry> entryEnum = zipFile.entries();
            while (entryEnum.hasMoreElements()) {
                ZipEntry entry = entryEnum.nextElement();
                String entryName = entry.getName();
                File destFile = new File(outputDir, entryName);
                if (entry.isDirectory()) continue;
                File parentDir = destFile.getParentFile();
                if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                    throw new WindupException("Unable to create directory: " + parentDir.getAbsolutePath());
                }
                InputStream zipInputStream = zipFile.getInputStream(entry);
                try (FileOutputStream outputStream = new FileOutputStream(destFile);){
                    Streams.write((InputStream)zipInputStream, (OutputStream)outputStream);
                }
                finally {
                    if (zipInputStream == null) continue;
                    zipInputStream.close();
                }
            }
        }
    }

    public static String getEndsWithZipRegularExpression() {
        String regex;
        Set<String> zipExtensions = ZipUtil.getZipExtensions();
        if (zipExtensions.size() == 1) {
            regex = ".+\\." + zipExtensions.iterator().next() + "$";
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("\\b(");
            for (String value : zipExtensions) {
                builder.append("|");
                builder.append(value);
            }
            builder.append(")\\b");
            regex = ".+\\." + builder.toString() + "$";
        }
        return regex;
    }

    public static boolean endsWithZipExtension(String path) {
        for (String extension : ZipUtil.getZipExtensions()) {
            if (!StringUtils.endsWith((CharSequence)path, (CharSequence)("." + extension))) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getZipExtensions() {
        if (supportedExtensions == null) {
            HashSet<String> extensions = new HashSet<String>();
            extensions.add("war");
            extensions.add("ear");
            extensions.add("jar");
            extensions.add("sar");
            extensions.add("rar");
            extensions.add("zip");
            supportedExtensions = extensions;
        }
        return supportedExtensions;
    }

    public static List<String> scanZipFile(Path zipFilePath, boolean relativeOnly) {
        List<String> list;
        FileInputStream is = new FileInputStream(zipFilePath.toFile());
        try {
            list = ZipUtil.scanZipFile(zipFilePath.normalize().toString(), is, relativeOnly);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Could not read file: " + zipFilePath + " due to: " + e.getMessage());
                return Collections.emptyList();
            }
        }
        ((InputStream)is).close();
        return list;
    }

    public static List<String> scanZipFile(String parentPath, InputStream is, boolean relativeOnly) {
        try {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(is);
            ArrayList<String> results = new ArrayList<String>();
            while ((entry = ZipUtil.getNextEntry(zis)) != null) {
                String fullPath = parentPath + "/" + entry.getName();
                results.add((String)(relativeOnly ? entry.getName() : fullPath));
                if (entry.isDirectory() || !ZipUtil.endsWithZipExtension(entry.getName())) continue;
                results.addAll(ZipUtil.scanZipFile(fullPath, zis, relativeOnly));
            }
            return results;
        }
        catch (IOException e) {
            System.err.println("Could not read file: " + parentPath + " due to: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    private static ZipEntry getNextEntry(ZipInputStream zis) throws IOException {
        try {
            return zis.getNextEntry();
        }
        catch (IllegalArgumentException e) {
            return ZipUtil.getNextEntry(zis);
        }
    }

    public static void zipFolder(final Path source, String zipOutputPath, final String zipOutputName, final List<String> pathPrefixesToExclude) throws IOException {
        File outputFile = new File(zipOutputPath + File.separator + zipOutputName);
        URI outputFileURI = outputFile.toURI();
        final URI uri = URI.create("jar:" + outputFileURI);
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                Path targetFile;
                block14: {
                    block13: {
                        targetFile = source.relativize(file);
                        if (attributes.isSymbolicLink() || file.endsWith(zipOutputName)) break block13;
                        if (!pathPrefixesToExclude.stream().anyMatch(targetFile::startsWith)) break block14;
                    }
                    return FileVisitResult.CONTINUE;
                }
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("create", "true");
                try (FileSystem zip = FileSystems.newFileSystem(uri, env);){
                    Path pathInZipfile = zip.getPath(targetFile.toString(), new String[0]);
                    if (pathInZipfile.getParent() != null) {
                        Files.createDirectories(pathInZipfile.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(file, pathInZipfile, COPY_OPTIONS);
                }
                catch (IOException e) {
                    throw new WindupException(e);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                String message = String.format("Unable to zip : %s%n%s%n", file, exc);
                log.warning(message);
                System.err.println(message);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static {
        COPY_OPTIONS = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS};
    }
}

