/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dbunit.Assertion;
import org.dbunit.DBTestCase;
import org.dbunit.DatabaseUnitException;
import org.dbunit.DefaultExpectedDataSetAndVerifyTableDefinitionVerifier;
import org.dbunit.ExpectedDataSetAndVerifyTableDefinitionVerifier;
import org.dbunit.IDatabaseTester;
import org.dbunit.PrepAndExpectedTestCase;
import org.dbunit.PrepAndExpectedTestCaseSteps;
import org.dbunit.VerifyTableDefinition;
import org.dbunit.assertion.comparer.value.ValueComparer;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.SortedTable;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.util.TableFormatter;
import org.dbunit.util.fileloader.DataFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPrepAndExpectedTestCase
extends DBTestCase
implements PrepAndExpectedTestCase {
    private final Logger log = LoggerFactory.getLogger(DefaultPrepAndExpectedTestCase.class);
    private static final String DATABASE_TESTER_IS_NULL_MSG = "databaseTester is null; must configure or set it first";
    public static final String TEST_ERROR_MSG = "DbUnit test error.";
    private IDatabaseTester databaseTester;
    private DataFileLoader dataFileLoader;
    private IDataSet prepDataSet = new DefaultDataSet();
    private IDataSet expectedDataSet = new DefaultDataSet();
    private VerifyTableDefinition[] verifyTableDefs = new VerifyTableDefinition[0];
    private ExpectedDataSetAndVerifyTableDefinitionVerifier expectedDataSetAndVerifyTableDefinitionVerifier = new DefaultExpectedDataSetAndVerifyTableDefinitionVerifier();
    final TableFormatter tableFormatter = new TableFormatter();

    public DefaultPrepAndExpectedTestCase() {
    }

    public DefaultPrepAndExpectedTestCase(DataFileLoader dataFileLoader, IDatabaseTester databaseTester) {
        this.dataFileLoader = dataFileLoader;
        this.databaseTester = databaseTester;
    }

    public DefaultPrepAndExpectedTestCase(String name) {
        super(name);
    }

    @Override
    public IDatabaseTester newDatabaseTester() throws Exception {
        return this.databaseTester;
    }

    @Override
    public IDataSet getDataSet() throws Exception {
        return this.prepDataSet;
    }

    @Override
    public void configureTest(VerifyTableDefinition[] verifyTableDefinitions, String[] prepDataFiles, String[] expectedDataFiles) throws Exception {
        this.log.info("configureTest: saving instance variables");
        boolean isCaseSensitiveTableNames = this.lookupFeatureValue("http://www.dbunit.org/features/caseSensitiveTableNames");
        this.log.info("configureTest: using case sensitive table names={}", (Object)isCaseSensitiveTableNames);
        this.prepDataSet = this.makeCompositeDataSet(prepDataFiles, "prep", isCaseSensitiveTableNames);
        this.expectedDataSet = this.makeCompositeDataSet(expectedDataFiles, "expected", isCaseSensitiveTableNames);
        this.verifyTableDefs = verifyTableDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lookupFeatureValue(String featureName) throws Exception {
        boolean featureValue;
        try (IDatabaseConnection connection = null;){
            connection = this.getConnection();
            DatabaseConfig config = connection.getConfig();
            featureValue = config.getFeature(featureName);
        }
        return featureValue;
    }

    @Override
    public void preTest() throws Exception {
        this.setupData();
    }

    @Override
    public void preTest(VerifyTableDefinition[] tables, String[] prepDataFiles, String[] expectedDataFiles) throws Exception {
        this.configureTest(tables, prepDataFiles, expectedDataFiles);
        this.preTest();
    }

    @Override
    public Object runTest(VerifyTableDefinition[] verifyTables, String[] prepDataFiles, String[] expectedDataFiles, PrepAndExpectedTestCaseSteps testSteps) throws Exception {
        Object result;
        try {
            this.preTest(verifyTables, prepDataFiles, expectedDataFiles);
            this.log.info("runTest: running test steps");
            result = testSteps.run();
        }
        catch (Throwable e) {
            this.log.error(TEST_ERROR_MSG, e);
            this.postTest(false);
            throw e;
        }
        this.postTest();
        return result;
    }

    @Override
    public void postTest() throws Exception {
        this.postTest(true);
    }

    @Override
    public void postTest(boolean verifyData) throws Exception {
        try {
            if (verifyData) {
                this.verifyData();
            }
        }
        finally {
            this.cleanupData();
        }
    }

    @Override
    public void cleanupData() throws Exception {
        try {
            boolean isCaseSensitiveTableNames = this.lookupFeatureValue("http://www.dbunit.org/features/caseSensitiveTableNames");
            this.log.info("cleanupData: using case sensitive table names={}", (Object)isCaseSensitiveTableNames);
            IDataSet[] dataSets = new IDataSet[]{this.prepDataSet, this.expectedDataSet};
            CompositeDataSet dataset = new CompositeDataSet(dataSets, true, isCaseSensitiveTableNames);
            String[] tableNames = dataset.getTableNames();
            int count = tableNames.length;
            this.log.info("cleanupData: about to clean up {} tables={}", (Object)count, (Object)tableNames);
            if (this.databaseTester == null) {
                throw new IllegalStateException(DATABASE_TESTER_IS_NULL_MSG);
            }
            this.databaseTester.setTearDownOperation(this.getTearDownOperation());
            this.databaseTester.setDataSet(dataset);
            this.databaseTester.setOperationListener(this.getOperationListener());
            this.databaseTester.onTearDown();
            this.log.debug("cleanupData: Clean up done");
        }
        catch (Exception e) {
            this.log.error("cleanupData: Exception:", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.cleanupData();
        super.tearDown();
    }

    public void setupData() throws Exception {
        this.log.info("setupData: setting prep dataset and inserting rows");
        if (this.databaseTester == null) {
            throw new IllegalStateException(DATABASE_TESTER_IS_NULL_MSG);
        }
        try {
            super.setUp();
        }
        catch (Exception e) {
            this.log.error("setupData: Exception with setting up data:", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected DatabaseOperation getSetUpOperation() throws Exception {
        DefaultPrepAndExpectedTestCase.assertNotNull((String)DATABASE_TESTER_IS_NULL_MSG, (Object)this.databaseTester);
        return this.databaseTester.getSetUpOperation();
    }

    @Override
    protected DatabaseOperation getTearDownOperation() throws Exception {
        DefaultPrepAndExpectedTestCase.assertNotNull((String)DATABASE_TESTER_IS_NULL_MSG, (Object)this.databaseTester);
        return this.databaseTester.getTearDownOperation();
    }

    @Override
    public void verifyData() throws Exception {
        if (this.databaseTester == null) {
            throw new IllegalStateException(DATABASE_TESTER_IS_NULL_MSG);
        }
        IDatabaseConnection connection = this.getConnection();
        DatabaseConfig config = connection.getConfig();
        this.expectedDataSetAndVerifyTableDefinitionVerifier.verify(this.verifyTableDefs, this.expectedDataSet, config);
        try {
            int tableDefsCount = this.verifyTableDefs.length;
            this.log.info("verifyData: about to verify {} tables using verifyTableDefinitions={}", (Object)tableDefsCount, (Object)this.verifyTableDefs);
            if (tableDefsCount == 0) {
                this.log.warn("verifyData: No tables to verify as no VerifyTableDefinitions specified");
            }
            for (int i = 0; i < tableDefsCount; ++i) {
                VerifyTableDefinition td = this.verifyTableDefs[i];
                this.verifyData(connection, td);
            }
        }
        catch (Exception e) {
            this.log.error("verifyData: Exception:", (Throwable)e);
            throw e;
        }
        finally {
            this.log.debug("verifyData: Verification done, closing connection");
            connection.close();
        }
    }

    protected void verifyData(IDatabaseConnection connection, VerifyTableDefinition verifyTableDefinition) throws Exception {
        String tableName = verifyTableDefinition.getTableName();
        this.log.info("verifyData: Verifying table '{}'", (Object)tableName);
        String[] excludeColumns = verifyTableDefinition.getColumnExclusionFilters();
        String[] includeColumns = verifyTableDefinition.getColumnInclusionFilters();
        Map<String, ValueComparer> columnValueComparers = verifyTableDefinition.getColumnValueComparers();
        ValueComparer defaultValueComparer = verifyTableDefinition.getDefaultValueComparer();
        ITable expectedTable = this.loadTableDataFromDataSet(tableName);
        ITable actualTable = this.loadTableDataFromDatabase(tableName, connection);
        this.verifyData(expectedTable, actualTable, excludeColumns, includeColumns, defaultValueComparer, columnValueComparers);
    }

    public ITable loadTableDataFromDataSet(String tableName) throws DataSetException {
        ITable table = null;
        String methodName = "loadTableDataFromDataSet";
        this.log.debug("{}: Loading table {} from expected dataset", (Object)"loadTableDataFromDataSet", (Object)tableName);
        try {
            table = this.expectedDataSet.getTable(tableName);
        }
        catch (Exception e) {
            String msg = "loadTableDataFromDataSet: Problem obtaining table '" + tableName + "' from expected dataset";
            this.log.error(msg, (Throwable)e);
            throw new DataSetException(msg, e);
        }
        return table;
    }

    public ITable loadTableDataFromDatabase(String tableName, IDatabaseConnection connection) throws Exception {
        ITable table = null;
        String methodName = "loadTableDataFromDatabase";
        this.log.debug("{}: Loading table {} from database", (Object)"loadTableDataFromDatabase", (Object)tableName);
        try {
            table = connection.createTable(tableName);
        }
        catch (Exception e) {
            String msg = "loadTableDataFromDatabase: Problem obtaining table '" + tableName + "' from database";
            this.log.error(msg, (Throwable)e);
            throw new DataSetException(msg, e);
        }
        return table;
    }

    protected void verifyData(ITable expectedTable, ITable actualTable, String[] excludeColumns, String[] includeColumns, ValueComparer defaultValueComparer, Map<String, ValueComparer> columnValueComparers) throws DatabaseUnitException {
        String methodName = "verifyData";
        ITableMetaData actualTableMetaData = actualTable.getTableMetaData();
        ITableMetaData expectedTableMetaData = expectedTable.getTableMetaData();
        Column[] actualTableColumns = actualTableMetaData.getColumns();
        Column[] expectedTableColumns = this.makeExpectedTableColumns(actualTableColumns, expectedTableMetaData);
        this.log.debug("{}: Sorting expected table using all columns", (Object)"verifyData");
        SortedTable expectedSortedTable = new SortedTable(expectedTable, expectedTableColumns, true);
        expectedSortedTable.setUseComparable(true);
        this.log.debug("{}: Sorted expected table={}", (Object)"verifyData", (Object)expectedSortedTable);
        this.log.debug("{}: Sorting actual table using all columns", (Object)"verifyData");
        SortedTable actualSortedTable = new SortedTable(actualTable, actualTableColumns);
        actualSortedTable.setUseComparable(true);
        this.log.debug("{}: Sorted actual table={}", (Object)"verifyData", (Object)actualSortedTable);
        this.log.debug("{}: Applying column exclude and include filters to sorted expected table", (Object)"verifyData");
        ITable expectedFilteredTable = this.applyColumnFilters(expectedSortedTable, excludeColumns, includeColumns);
        this.log.debug("{}: Applying column exclude and include filters to sorted actual table", (Object)"verifyData");
        ITable actualFilteredTable = this.applyColumnFilters(actualSortedTable, excludeColumns, includeColumns);
        this.log.debug("{}: Creating additionalColumnInfo for expected table", (Object)"verifyData");
        Column[] additionalColumnInfo = this.makeAdditionalColumnInfo(expectedTable, excludeColumns);
        this.log.debug("{}: additionalColumnInfo={}", (Object)"verifyData", (Object)additionalColumnInfo);
        this.logSortedTables(expectedSortedTable, actualSortedTable);
        this.log.debug("{}: Comparing expected table to actual table", (Object)"verifyData");
        this.compareData(expectedFilteredTable, actualFilteredTable, additionalColumnInfo, defaultValueComparer, columnValueComparers);
    }

    private Column[] makeExpectedTableColumns(Column[] actualColumns, ITableMetaData expectedTableMetaData) throws DataSetException {
        DataType dataType;
        Column[] expectedColumns = expectedTableMetaData.getColumns();
        Column[] expectedTableColumns = expectedColumns.length > 0 ? (DataType.UNKNOWN.equals(dataType = expectedColumns[0].getDataType()) ? this.makeExpectedTableColumns(actualColumns, expectedColumns) : expectedColumns) : expectedColumns;
        return expectedTableColumns;
    }

    private Column[] makeExpectedTableColumns(Column[] actualColumns, Column[] expectedColumns) {
        Set expectedColumnNames = Arrays.stream(expectedColumns).map(Column::getColumnName).map(String::toLowerCase).collect(Collectors.toSet());
        List<Column> expectedColumnsList = Arrays.stream(actualColumns).filter(col -> expectedColumnNames.contains(col.getColumnName().toLowerCase())).collect(Collectors.toList());
        return expectedColumnsList.toArray(new Column[expectedColumnsList.size()]);
    }

    private void logSortedTables(SortedTable expectedSortedTable, SortedTable actualSortedTable) {
        if (this.log.isTraceEnabled()) {
            this.logSortedTable("expectedSortedTable", expectedSortedTable);
            this.logSortedTable("actualSortedTable", actualSortedTable);
        }
    }

    private void logSortedTable(String tableTypeName, SortedTable table) {
        String methodName = "logSortedTable:";
        Column[] sortColumns = table.getSortColumns();
        this.log.trace("{} {} sortColumns={}", new Object[]{"logSortedTable:", tableTypeName, sortColumns});
        try {
            String tableContents = this.tableFormatter.format(table);
            this.log.trace("{} {} tableContents={}", new Object[]{"logSortedTable:", tableTypeName, tableContents});
        }
        catch (DataSetException e) {
            this.log.error("{} Error trying to log table={}", new Object[]{"logSortedTable:", tableTypeName, e});
        }
    }

    protected void compareData(ITable expectedTable, ITable actualTable, Column[] additionalColumnInfo, ValueComparer defaultValueComparer, Map<String, ValueComparer> columnValueComparers) throws DatabaseUnitException {
        Assertion.assertWithValueComparer(expectedTable, actualTable, additionalColumnInfo, defaultValueComparer, columnValueComparers);
    }

    protected Column[] makeAdditionalColumnInfo(ITable expectedTable, String[] excludeColumns) throws DataSetException {
        Column[] allColumns = expectedTable.getTableMetaData().getColumns();
        return excludeColumns == null ? allColumns : this.makeAdditionalColumnInfo(excludeColumns, allColumns);
    }

    protected Column[] makeAdditionalColumnInfo(String[] excludeColumns, Column[] allColumns) {
        ArrayList<Column> keepColumnsList = new ArrayList<Column>();
        List<String> excludeColumnsList = Arrays.asList(excludeColumns);
        for (Column column : allColumns) {
            String columnName = column.getColumnName();
            if (excludeColumnsList.contains(columnName)) continue;
            keepColumnsList.add(column);
        }
        return keepColumnsList.toArray(new Column[keepColumnsList.size()]);
    }

    public IDataSet makeCompositeDataSet(String[] dataFiles, String dataFilesName) throws DataSetException {
        return this.makeCompositeDataSet(dataFiles, dataFilesName, false);
    }

    public IDataSet makeCompositeDataSet(String[] dataFiles, String dataFilesName, boolean isCaseSensitiveTableNames) throws DataSetException {
        if (this.dataFileLoader == null) {
            throw new IllegalStateException("dataFileLoader is null; must configure or set it first");
        }
        int count = dataFiles.length;
        this.log.debug("makeCompositeDataSet: {} dataFiles count={}", (Object)dataFilesName, (Object)count);
        if (count == 0) {
            this.log.info("makeCompositeDataSet: Specified zero {} data files", (Object)dataFilesName);
        }
        ArrayList<IDataSet> list = new ArrayList<IDataSet>();
        for (int i = 0; i < count; ++i) {
            IDataSet ds = this.dataFileLoader.load(dataFiles[i]);
            list.add(ds);
        }
        IDataSet[] dataSet = list.toArray(new IDataSet[0]);
        CompositeDataSet compositeDS = new CompositeDataSet(dataSet, true, isCaseSensitiveTableNames);
        return compositeDS;
    }

    public ITable applyColumnFilters(ITable table, String[] excludeColumns, String[] includeColumns) throws DataSetException {
        ITable filteredTable = table;
        if (table == null) {
            throw new IllegalArgumentException("table is null");
        }
        if (includeColumns == null) {
            this.log.debug("applyColumnFilters: including columns=(all)");
        } else {
            this.log.debug("applyColumnFilters: including columns='{}'", new Object[]{includeColumns});
            filteredTable = DefaultColumnFilter.includedColumnsTable(filteredTable, includeColumns);
        }
        if (excludeColumns == null || excludeColumns.length == 0) {
            this.log.debug("applyColumnFilters: excluding columns=(none)");
        } else {
            this.log.debug("applyColumnFilters: excluding columns='{}'", new Object[]{excludeColumns});
            filteredTable = DefaultColumnFilter.excludedColumnsTable(filteredTable, excludeColumns);
        }
        return filteredTable;
    }

    @Override
    public IDataSet getPrepDataset() {
        return this.prepDataSet;
    }

    @Override
    public IDataSet getExpectedDataset() {
        return this.expectedDataSet;
    }

    @Override
    public IDatabaseTester getDatabaseTester() {
        return this.databaseTester;
    }

    public void setDatabaseTester(IDatabaseTester databaseTester) {
        this.databaseTester = databaseTester;
    }

    public DataFileLoader getDataFileLoader() {
        return this.dataFileLoader;
    }

    public void setDataFileLoader(DataFileLoader dataFileLoader) {
        this.dataFileLoader = dataFileLoader;
    }

    public void setPrepDs(IDataSet prepDataSet) {
        this.prepDataSet = prepDataSet;
    }

    public void setExpectedDs(IDataSet expectedDataSet) {
        this.expectedDataSet = expectedDataSet;
    }

    public VerifyTableDefinition[] getVerifyTableDefs() {
        return this.verifyTableDefs;
    }

    public void setVerifyTableDefs(VerifyTableDefinition[] verifyTableDefs) {
        this.verifyTableDefs = verifyTableDefs;
    }

    public ExpectedDataSetAndVerifyTableDefinitionVerifier getExpectedDataSetAndVerifyTableDefinitionVerifier() {
        return this.expectedDataSetAndVerifyTableDefinitionVerifier;
    }

    public void setExpectedDataSetAndVerifyTableDefinitionVerifier(ExpectedDataSetAndVerifyTableDefinitionVerifier expectedDataSetAndVerifyTableDefinitionVerifier) {
        this.expectedDataSetAndVerifyTableDefinitionVerifier = expectedDataSetAndVerifyTableDefinitionVerifier;
    }
}

