/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableIterator
implements ITableIterator {
    private Logger logger = LoggerFactory.getLogger(DefaultTableIterator.class);
    private final ITable[] _tables;
    private int _index = -1;

    public DefaultTableIterator(ITable[] tables) {
        this._tables = tables;
    }

    public DefaultTableIterator(ITable[] tables, boolean reversed) {
        if (reversed) {
            ITable[] reverseTables = new ITable[tables.length];
            for (int i = 0; i < tables.length; ++i) {
                reverseTables[tables.length - 1 - i] = tables[i];
            }
            tables = reverseTables;
        }
        this._tables = tables;
    }

    @Override
    public boolean next() throws DataSetException {
        ++this._index;
        return this._index < this._tables.length;
    }

    @Override
    public ITableMetaData getTableMetaData() throws DataSetException {
        this.logger.debug("getTableMetaData() - start");
        return this.getTable().getTableMetaData();
    }

    @Override
    public ITable getTable() throws DataSetException {
        this.logger.debug("getTable() - start");
        return this._tables[this._index];
    }
}

