/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import com.google.api.client.json.JsonFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;

class GoogleJsonUtil {
    static final JsonFactory JSON_FACTORY;
    static final String JACKSON = "com.google.api.client.json.jackson2.JacksonFactory";
    static final String GSON = "com.google.api.client.json.gson.GsonFactory";

    GoogleJsonUtil() {
    }

    private static JsonFactory instantiate(String name) throws ClassNotFoundException {
        return (JsonFactory)BeanUtils.instantiateClass((Class)ClassUtils.forName((String)name, null));
    }

    static {
        try {
            JSON_FACTORY = ClassUtils.isPresent((String)JACKSON, null) ? GoogleJsonUtil.instantiate(JACKSON) : GoogleJsonUtil.instantiate(GSON);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("No com.google.api.client.json.JsonFactory implementation available. Make sure to include either %s or %s on your classpath.", JACKSON, GSON), e);
        }
    }
}

