/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Locale;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.boot.model.AttributeContainer;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.internal.metadata.AbstractMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.BasicMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.CollectionMetadataContext;
import org.hibernate.envers.configuration.internal.metadata.ComponentMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.EntityMappingData;
import org.hibernate.envers.configuration.internal.metadata.JoinColumnCollectionMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.MiddleTableCollectionMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.ToOneRelationMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.internal.tools.MappingTools;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.Value;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

public class ValueMetadataGenerator
extends AbstractMetadataGenerator {
    private final BasicMetadataGenerator basicMetadataGenerator;
    private final ComponentMetadataGenerator componentMetadataGenerator;
    private final ToOneRelationMetadataGenerator toOneRelationMetadataGenerator;
    private final JoinColumnCollectionMetadataGenerator joinedColumnCollectionGenerator;
    private final MiddleTableCollectionMetadataGenerator middleTableCollectionGenerator;

    public ValueMetadataGenerator(EnversMetadataBuildingContext metadataBuildingContext, BasicMetadataGenerator basicMetadataGenerator) {
        super(metadataBuildingContext);
        this.basicMetadataGenerator = basicMetadataGenerator;
        this.componentMetadataGenerator = new ComponentMetadataGenerator(metadataBuildingContext, this);
        this.toOneRelationMetadataGenerator = new ToOneRelationMetadataGenerator(metadataBuildingContext);
        this.joinedColumnCollectionGenerator = new JoinColumnCollectionMetadataGenerator(metadataBuildingContext, basicMetadataGenerator, this);
        this.middleTableCollectionGenerator = new MiddleTableCollectionMetadataGenerator(metadataBuildingContext, basicMetadataGenerator, this);
    }

    public void addValue(AttributeContainer attributeContainer, Value value, PropertyAccessStrategy propertyAccessStrategy, CompositeMapperBuilder currentMapper, String entityName, EntityMappingData mappingData, PropertyAuditingData propertyAuditingData, boolean insertable, boolean firstPass, boolean processModifiedFlags) {
        if (firstPass) {
            this.addValueInFirstPass(attributeContainer, value, propertyAccessStrategy, currentMapper, entityName, mappingData, propertyAuditingData, insertable, processModifiedFlags);
        } else {
            this.addValueInSecondPass(attributeContainer, value, propertyAccessStrategy, currentMapper, entityName, mappingData, propertyAuditingData, insertable, processModifiedFlags);
        }
    }

    private void addValueInFirstPass(AttributeContainer attributeContainer, Value value, PropertyAccessStrategy propertyAccessStrategy, CompositeMapperBuilder currentMapper, String entityName, EntityMappingData mappingData, PropertyAuditingData propertyAuditingData, boolean insertable, boolean processModifiedFlag) {
        Type type = value.getType();
        propertyAuditingData.setPropertyAccessStrategy(propertyAccessStrategy);
        if (type instanceof BasicType) {
            this.basicMetadataGenerator.addBasic(attributeContainer, propertyAuditingData, value, currentMapper, insertable, false);
        } else if (type instanceof ComponentType) {
            this.componentMetadataGenerator.addComponent(attributeContainer, propertyAuditingData, value, currentMapper, entityName, mappingData, true);
        } else {
            if (!this.processedInSecondPass(type)) {
                this.throwUnsupportedTypeException(type, entityName, propertyAuditingData.getName());
            }
            return;
        }
        if (this.isModifiedFlagsAllowed(processModifiedFlag, propertyAuditingData)) {
            this.addModifiedFlags(attributeContainer, propertyAuditingData, value);
        }
    }

    private void addValueInSecondPass(AttributeContainer attributeContainer, Value value, PropertyAccessStrategy propertyAccessStrategy, final CompositeMapperBuilder currentMapper, final String entityName, final EntityMappingData mappingData, final PropertyAuditingData propertyAuditingData, boolean insertable, boolean processModifiedFlag) {
        Type type = value.getType();
        if (type instanceof ComponentType) {
            this.componentMetadataGenerator.addComponent(attributeContainer, propertyAuditingData, value, currentMapper, entityName, mappingData, false);
            return;
        }
        if (type instanceof ManyToOneType) {
            this.toOneRelationMetadataGenerator.addToOne(attributeContainer, propertyAuditingData, value, currentMapper, entityName, insertable);
        } else if (type instanceof OneToOneType) {
            OneToOne oneToOne = (OneToOne)value;
            if (oneToOne.getReferencedPropertyName() != null) {
                this.toOneRelationMetadataGenerator.addOneToOneNotOwning(propertyAuditingData, value, currentMapper, entityName);
            } else {
                this.toOneRelationMetadataGenerator.addOneToOnePrimaryKeyJoinColumn(propertyAuditingData, value, currentMapper, entityName, insertable);
            }
        } else if (type instanceof CollectionType) {
            final EntityConfiguration referencingEntityConfiguration = this.getAuditedEntityConfiguration(entityName);
            if (referencingEntityConfiguration == null) {
                throw new EnversMappingException(String.format(Locale.ENGLISH, "Unable to read auditing configuration for %s!", entityName));
            }
            final Collection collection = (Collection)value;
            final String referencedEntityName = MappingTools.getReferencedEntityName(collection.getElement());
            CollectionMetadataContext context = new CollectionMetadataContext(){

                @Override
                public EntityMappingData getEntityMappingData() {
                    return mappingData;
                }

                @Override
                public Collection getCollection() {
                    return collection;
                }

                @Override
                public CompositeMapperBuilder getMapperBuilder() {
                    return currentMapper;
                }

                @Override
                public String getReferencedEntityName() {
                    return referencedEntityName;
                }

                @Override
                public String getReferencingEntityName() {
                    return entityName;
                }

                @Override
                public EntityConfiguration getReferencingEntityConfiguration() {
                    return referencingEntityConfiguration;
                }

                @Override
                public PropertyAuditingData getPropertyAuditingData() {
                    return propertyAuditingData;
                }
            };
            if (context.isMiddleTableCollection()) {
                this.middleTableCollectionGenerator.addCollection(context);
            } else {
                this.joinedColumnCollectionGenerator.addCollection(context);
            }
        } else {
            return;
        }
        if (this.isModifiedFlagsAllowed(processModifiedFlag, propertyAuditingData)) {
            this.addModifiedFlags(attributeContainer, propertyAuditingData, value);
        }
    }

    private boolean processedInSecondPass(Type type) {
        return type instanceof ComponentType || type instanceof ManyToOneType || type instanceof OneToOneType || type instanceof CollectionType;
    }

    private boolean isModifiedFlagsAllowed(boolean processModifiedFlags, PropertyAuditingData propertyAuditingData) {
        return processModifiedFlags && propertyAuditingData.isUsingModifiedFlag();
    }

    private void addModifiedFlags(AttributeContainer attributeContainer, PropertyAuditingData propertyAuditingData, Value value) {
        this.getMetadataBuildingContext().getConfiguration().getModifiedColumnNamingStrategy().addModifiedColumns(this.getMetadataBuildingContext().getConfiguration(), value, attributeContainer, propertyAuditingData);
    }
}

