/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import java.util.Map;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.AuditFunction;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class FunctionPropertyAuditExpression
implements AuditCriterion {
    private String alias;
    private PropertyNameGetter propertyNameGetter;
    private AuditFunction function;
    private String op;

    public FunctionPropertyAuditExpression(String alias, PropertyNameGetter propertyNameGetter, AuditFunction function, String op) {
        this.alias = alias;
        this.propertyNameGetter = propertyNameGetter;
        this.function = function;
        this.op = op;
    }

    @Override
    public void addToQuery(EnversService enversService, AuditReaderImplementor auditReader, Map<String, String> aliasToEntityNameMap, Map<String, String> aliasToComponentPropertyNameMap, String baseAlias, QueryBuilder queryBuilder, Parameters parameters) {
        String effectiveAlias = this.alias == null ? baseAlias : this.alias;
        String entityName = aliasToEntityNameMap.get(effectiveAlias);
        String propertyName = CriteriaTools.determinePropertyName(enversService, auditReader, entityName, this.propertyNameGetter);
        String propertyNamePrefix = CriteriaTools.determineComponentPropertyPrefix(enversService, aliasToEntityNameMap, aliasToComponentPropertyNameMap, effectiveAlias);
        String prefixedPropertyName = propertyNamePrefix.concat(propertyName);
        CriteriaTools.checkPropertyNotARelation(enversService, entityName, prefixedPropertyName);
        parameters.addWhereWithFunction(enversService.getConfig(), aliasToEntityNameMap, aliasToComponentPropertyNameMap, effectiveAlias, prefixedPropertyName, this.op, this.function);
    }
}

