/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.strategy.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.model.BasicAttribute;
import org.hibernate.envers.boot.model.Column;
import org.hibernate.envers.boot.model.ManyToOneAttribute;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.configuration.internal.metadata.RevisionInfoHelper;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.internal.synchronization.SessionCacheCleaner;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.strategy.spi.AuditStrategyContext;
import org.hibernate.envers.strategy.spi.MappingContext;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.sql.ComparisonRestriction;
import org.hibernate.sql.Update;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.MapType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.WrapperOptions;

public class ValidityAuditStrategy
implements AuditStrategy {
    private Getter revisionTimestampGetter;
    private final SessionCacheCleaner sessionCacheCleaner = new SessionCacheCleaner();

    @Override
    public void postInitialize(AuditStrategyContext context) {
        this.setRevisionTimestampGetter(context.getRevisionInfoTimestampAccessor());
    }

    @Override
    public void addAdditionalColumns(MappingContext mappingContext) {
        if (!mappingContext.isRevisionEndTimestampOnly()) {
            ManyToOneAttribute revEndMapping = new ManyToOneAttribute(mappingContext.getConfiguration().getRevisionEndFieldName(), mappingContext.getRevisionInfoPropertyType(), true, true, false, mappingContext.getRevisionInfoExplicitTypeName());
            RevisionInfoHelper.addOrModifyColumn(revEndMapping, mappingContext.getConfiguration().getRevisionEndFieldName());
            mappingContext.getEntityMapping().addAttribute(revEndMapping);
        }
        if (mappingContext.getConfiguration().isRevisionEndTimestampEnabled()) {
            String revisionInfoTimestampTypeName = mappingContext.getConfiguration().isRevisionEndTimestampNumeric() ? StandardBasicTypes.LONG.getName() : StandardBasicTypes.TIMESTAMP.getName();
            Object revEndTimestampPropertyName = mappingContext.getConfiguration().getRevisionEndTimestampFieldName();
            String revEndTimestampColumnName = revEndTimestampPropertyName;
            if (!mappingContext.getConfiguration().isRevisionEndTimestampUseLegacyPlacement() && mappingContext.isRevisionEndTimestampOnly()) {
                revEndTimestampPropertyName = mappingContext.getConfiguration().getRevisionEndTimestampFieldName() + "_" + mappingContext.getEntityMapping().getAuditTableData().getAuditTableName();
            }
            BasicAttribute revEndTimestampMapping = new BasicAttribute((String)revEndTimestampPropertyName, revisionInfoTimestampTypeName, true, true, false);
            revEndTimestampMapping.addColumn(new Column(revEndTimestampColumnName));
            mappingContext.getEntityMapping().addAttribute(revEndTimestampMapping);
        }
    }

    @Override
    public void perform(Session session, String entityName, Configuration configuration, Object id, Object data, Object revision) {
        String auditedEntityName = configuration.getAuditEntityName(entityName);
        session.save(auditedEntityName, data);
        boolean reuseEntityIdentifier = configuration.isAllowIdentifierReuse();
        if (reuseEntityIdentifier || this.getRevisionType(configuration, data) != RevisionType.ADD) {
            ((EventSource)session).getActionQueue().registerProcess(sessionImplementor -> {
                List<UpdateContext> contexts = this.getUpdateContexts(entityName, auditedEntityName, sessionImplementor, configuration, id, revision);
                if (contexts.isEmpty()) {
                    throw new AuditException(String.format(Locale.ENGLISH, "Failed to build update contexts for entity %s and id %s", auditedEntityName, id));
                }
                for (UpdateContext context : contexts) {
                    int rows = this.executeUpdate(sessionImplementor, context);
                    if (rows == 1) continue;
                    RevisionType revisionType = this.getRevisionType(configuration, data);
                    if (reuseEntityIdentifier && revisionType == RevisionType.ADD) continue;
                    throw new AuditException(String.format(Locale.ENGLISH, "Cannot update previous revision for entity %s and id %s (%s rows modified).", auditedEntityName, id, rows));
                }
            });
        }
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, data);
    }

    @Override
    public void performCollectionChange(Session session, String entityName, String propertyName, Configuration configuration, PersistentCollectionChangeData persistentCollectionChangeData, Object revision) {
        QueryBuilder qb = new QueryBuilder(persistentCollectionChangeData.getEntityName(), "ee__", ((SharedSessionContractImplementor)session).getFactory());
        String originalIdPropName = configuration.getOriginalIdPropertyName();
        Map originalId = (Map)persistentCollectionChangeData.getData().get(originalIdPropName);
        String revisionFieldName = configuration.getRevisionFieldName();
        String revisionTypePropName = configuration.getRevisionTypePropertyName();
        String ordinalPropName = configuration.getEmbeddableSetOrdinalPropertyName();
        for (Map.Entry originalIdEntry : originalId.entrySet()) {
            if (revisionFieldName.equals(originalIdEntry.getKey()) || revisionTypePropName.equals(originalIdEntry.getKey()) || ordinalPropName.equals(originalIdEntry.getKey())) continue;
            qb.getRootParameters().addWhereWithParam(originalIdPropName + "." + (String)originalIdEntry.getKey(), true, "=", originalIdEntry.getValue());
        }
        if (this.isNonIdentifierWhereConditionsRequired(entityName, propertyName, (SessionImplementor)session)) {
            this.addNonIdentifierWhereConditions(qb, persistentCollectionChangeData.getData(), originalIdPropName);
        }
        this.addEndRevisionNullRestriction(configuration, qb.getRootParameters());
        List l = qb.toQuery(session).setHibernateFlushMode(FlushMode.MANUAL).setLockOptions(LockOptions.UPGRADE).list();
        if (l.size() > 0) {
            this.updateLastRevision(session, configuration, l, originalId, persistentCollectionChangeData.getEntityName(), revision);
        }
        session.save(persistentCollectionChangeData.getEntityName(), persistentCollectionChangeData.getData());
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, persistentCollectionChangeData.getData());
    }

    @Override
    public void addEntityAtRevisionRestriction(Configuration configuration, QueryBuilder rootQueryBuilder, Parameters parameters, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData idData, String revisionPropertyPath, String originalIdPropertyName, String alias1, String alias2, boolean inclusive) {
        this.addRevisionRestriction(parameters, revisionProperty, revisionEndProperty, addAlias, inclusive);
    }

    @Override
    public void addAssociationAtRevisionRestriction(QueryBuilder rootQueryBuilder, Parameters parameters, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData referencingIdData, String versionsMiddleEntityName, String eeOriginalIdPropertyPath, String revisionPropertyPath, String originalIdPropertyName, String alias1, boolean inclusive, MiddleComponentData ... componentDatas) {
        this.addRevisionRestriction(parameters, revisionProperty, revisionEndProperty, addAlias, inclusive);
    }

    @Deprecated(since="5.4")
    public void setRevisionTimestampGetter(Getter revisionTimestampGetter) {
        this.revisionTimestampGetter = revisionTimestampGetter;
    }

    private void addRevisionRestriction(Parameters rootParameters, String revisionProperty, String revisionEndProperty, boolean addAlias, boolean inclusive) {
        Parameters subParm = rootParameters.addSubParameters("or");
        rootParameters.addWhereWithNamedParam(revisionProperty, addAlias, inclusive ? "<=" : "<", "revision");
        subParm.addWhereWithNamedParam(revisionEndProperty + ".id", addAlias, inclusive ? ">" : ">=", "revision");
        subParm.addWhere(revisionEndProperty, addAlias, "is", "null", false);
    }

    private RevisionType getRevisionType(Configuration configuration, Object data) {
        return (RevisionType)((Object)((Map)data).get(configuration.getRevisionTypePropertyName()));
    }

    private void updateLastRevision(Session session, Configuration configuration, List<Object> l, Object id, String auditedEntityName, Object revision) {
        Object previousData;
        if (l.size() == 1) {
            previousData = l.get(0);
            String revisionEndFieldName = configuration.getRevisionEndFieldName();
            ((Map)previousData).put(revisionEndFieldName, revision);
            if (configuration.isRevisionEndTimestampEnabled()) {
                String revEndTimestampFieldName = configuration.getRevisionEndTimestampFieldName();
                Object revEndTimestampObj = this.revisionTimestampGetter.get(revision);
                Date revisionEndTimestamp = this.convertRevEndTimestampToDate(revEndTimestampObj);
                ((Map)previousData).put(revEndTimestampFieldName, revisionEndTimestamp);
            }
        } else {
            throw new RuntimeException("Cannot find previous revision for entity " + auditedEntityName + " and id " + id);
        }
        session.save(auditedEntityName, previousData);
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, previousData);
    }

    private Date convertRevEndTimestampToDate(Object revEndTimestampObj) {
        if (revEndTimestampObj instanceof Date) {
            return (Date)revEndTimestampObj;
        }
        return new Date((Long)revEndTimestampObj);
    }

    private Long convertRevEndTimestampToLong(Object revEndTimstampObj) {
        if (revEndTimstampObj instanceof Date) {
            return ((Date)revEndTimstampObj).getTime();
        }
        return (Long)revEndTimstampObj;
    }

    private Object getRevEndTimestampValue(Configuration configuration, Object value) {
        if (configuration.isRevisionEndTimestampNumeric()) {
            return this.convertRevEndTimestampToLong(value);
        }
        return this.convertRevEndTimestampToDate(value);
    }

    private Queryable getQueryable(String entityName, SessionImplementor sessionImplementor) {
        return (Queryable)sessionImplementor.getFactory().getMappingMetamodel().getEntityDescriptor(entityName);
    }

    private void addEndRevisionNullRestriction(Configuration configuration, Parameters rootParameters) {
        rootParameters.addWhere(configuration.getRevisionEndFieldName(), true, "is", "null", false);
    }

    private void addNonIdentifierWhereConditions(QueryBuilder qb, Map<String, Object> data, String originalIdPropertyName) {
        Parameters parameters = qb.getRootParameters();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (originalIdPropertyName.equals(entry.getKey())) continue;
            if (entry.getValue() != null) {
                parameters.addWhereWithParam(entry.getKey(), true, "=", entry.getValue());
                continue;
            }
            parameters.addNullRestriction(entry.getKey(), true);
        }
    }

    private boolean isNonIdentifierWhereConditionsRequired(String entityName, String propertyName, SessionImplementor session) {
        Type propertyType = session.getSessionFactory().getMappingMetamodel().getEntityDescriptor(entityName).getPropertyType(propertyName);
        if (propertyType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)propertyType;
            Type collectionElementType = collectionType.getElementType(session.getSessionFactory());
            if (collectionElementType instanceof ComponentType) {
                return true;
            }
            if (this.isMaterializedClob(collectionElementType)) {
                return collectionType instanceof MapType;
            }
        }
        return false;
    }

    private boolean isMaterializedClob(Type collectionElementType) {
        if (collectionElementType instanceof BasicType) {
            BasicType basicType = (BasicType)collectionElementType;
            return basicType.getJavaType() == String.class && (basicType.getJdbcType().getDdlTypeCode() == 2005 || basicType.getJdbcType().getDdlTypeCode() == 2011);
        }
        return false;
    }

    private int executeUpdate(SessionImplementor session, UpdateContext context) {
        String sql = context.toStatementString();
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        PreparedStatement statement = jdbcCoordinator.getStatementPreparer().prepareStatement(sql);
        return (Integer)session.doReturningWork(connection -> {
            try {
                int index = 1;
                for (QueryParameterBinding binding : context.getBindings()) {
                    index += binding.bind(index, statement, session);
                }
                int result = jdbcCoordinator.getResultSetReturn().executeUpdate(statement, sql);
                Integer n = result;
                return n;
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release((Statement)statement);
                jdbcCoordinator.afterStatementExecution();
            }
        });
    }

    private List<UpdateContext> getUpdateContexts(String entityName, String auditEntityName, SessionImplementor session, Configuration configuration, Object id, Object revision) {
        Queryable entity = this.getQueryable(entityName, session);
        ArrayList<UpdateContext> contexts = new ArrayList<UpdateContext>(0);
        if (configuration.isRevisionEndTimestampEnabled() && !configuration.isRevisionEndTimestampUseLegacyPlacement() && entity instanceof JoinedSubclassEntityPersister) {
            while (entity.getMappedSuperclass() != null) {
                contexts.add(this.getNonRootUpdateContext(entityName, auditEntityName, session, configuration, id, revision));
                entityName = entity.getEntityMappingType().getSuperMappingType().getEntityName();
                auditEntityName = configuration.getAuditEntityName(entityName);
                entity = this.getQueryable(entityName, session);
            }
        }
        contexts.add(this.getUpdateContext(entityName, auditEntityName, session, configuration, id, revision));
        return contexts;
    }

    private UpdateContext getUpdateContext(String entityName, String auditEntityName, SessionImplementor session, Configuration configuration, Object id, Object revision) {
        Queryable entity = this.getQueryable(entityName, session);
        Queryable rootEntity = this.getQueryable(entity.getRootEntityName(), session);
        Queryable auditEntity = this.getQueryable(auditEntityName, session);
        Queryable rootAuditEntity = this.getQueryable(auditEntity.getRootEntityName(), session);
        Queryable revisionEntity = this.getQueryable(configuration.getRevisionInfo().getRevisionInfoEntityName(), session);
        Number revisionNumber = this.getRevisionNumber(configuration, revision);
        UpdateContext context = new UpdateContext(session.getFactory());
        context.setTableName(this.getUpdateTableName(rootEntity, rootAuditEntity, auditEntity));
        String revEndAttributeName = configuration.getRevisionEndFieldName();
        String revEndColumnName = rootAuditEntity.findAttributeMapping(revEndAttributeName).getSelectable(0).getSelectionExpression();
        context.addAssignment(revEndColumnName);
        context.bind((Object)revisionNumber, (ModelPart)revisionEntity.getIdentifierMapping());
        if (configuration.isRevisionEndTimestampEnabled()) {
            Object revisionTimestamp = this.revisionTimestampGetter.get(revision);
            String revEndTimestampAttributeName = configuration.getRevisionEndTimestampFieldName();
            AttributeMapping revEndTimestampAttributeMapping = rootAuditEntity.findAttributeMapping(revEndTimestampAttributeName);
            context.addAssignment(revEndTimestampAttributeMapping.getSelectable(0).getSelectionExpression());
            context.bind(this.getRevEndTimestampValue(configuration, revisionTimestamp), (ModelPart)revEndTimestampAttributeMapping);
        }
        context.addRestriction(rootEntity.getIdentifierColumnNames());
        context.bind(id, (ModelPart)rootEntity.getIdentifierMapping());
        String path = configuration.getRevisionNumberPath();
        context.addRestriction(rootAuditEntity.toColumns(path)[0], ComparisonRestriction.Operator.NE, "?");
        context.bind((Object)revisionNumber, rootAuditEntity.getPropertyType(path));
        context.addColumnIsNullRestriction(revEndColumnName);
        return context;
    }

    private UpdateContext getNonRootUpdateContext(String entityName, String auditEntityName, SessionImplementor session, Configuration configuration, Object id, Object revision) {
        Queryable entity = this.getQueryable(entityName, session);
        Queryable auditEntity = this.getQueryable(auditEntityName, session);
        UpdateContext context = new UpdateContext(session.getFactory());
        context.setTableName(this.getUpdateTableName(entity, auditEntity, auditEntity));
        Object revisionTimestamp = this.revisionTimestampGetter.get(revision);
        String revEndTimestampAttributeName = configuration.getRevisionEndTimestampFieldName();
        AttributeMapping revEndTimestampAttributeMapping = auditEntity.findAttributeMapping(revEndTimestampAttributeName);
        String revEndTimestampColumnName = revEndTimestampAttributeMapping.getSelectable(0).getSelectionExpression();
        context.addAssignment(revEndTimestampColumnName);
        context.bind(this.getRevEndTimestampValue(configuration, revisionTimestamp), (ModelPart)revEndTimestampAttributeMapping);
        Number revisionNumber = this.getRevisionNumber(configuration, revision);
        context.addRestriction(entity.getIdentifierColumnNames());
        context.bind(id, entity.getIdentifierType());
        context.addRestriction(configuration.getRevisionFieldName(), ComparisonRestriction.Operator.NE, "?");
        context.bind((Object)revisionNumber, auditEntity.getPropertyType(configuration.getRevisionNumberPath()));
        context.addColumnIsNullRestriction(revEndTimestampColumnName);
        return context;
    }

    private Number getRevisionNumber(Configuration configuration, Object revisionEntity) {
        RevisionInfoNumberReader reader = configuration.getRevisionInfo().getRevisionInfoNumberReader();
        return reader.getRevisionNumber(revisionEntity);
    }

    private String getUpdateTableName(Queryable rootEntity, Queryable rootAuditEntity, Queryable auditEntity) {
        if (rootEntity instanceof UnionSubclassEntityPersister) {
            return auditEntity.getMappedTableDetails().getTableName();
        }
        return rootAuditEntity.getMappedTableDetails().getTableName();
    }

    private static class QueryParameterBindingPart
    implements QueryParameterBinding {
        private final ModelPart modelPart;
        private final Object value;

        public QueryParameterBindingPart(Object value, ModelPart modelPart) {
            this.value = value;
            this.modelPart = modelPart;
        }

        @Override
        public int bind(int index, PreparedStatement statement, SessionImplementor session) {
            try {
                return this.modelPart.breakDownJdbcValues(this.value, index, (Object)statement, (Object)session, (valueIndex, preparedStatement, sessionImplementor, jdbcValue, jdbcValueMapping) -> {
                    try {
                        jdbcValueMapping.getJdbcMapping().getJdbcValueBinder().bind(preparedStatement, jdbcValue, valueIndex, (WrapperOptions)sessionImplementor);
                    }
                    catch (SQLException e) {
                        throw new NestedRuntimeException(e);
                    }
                }, (SharedSessionContractImplementor)session);
            }
            catch (NestedRuntimeException e) {
                throw session.getJdbcServices().getSqlExceptionHelper().convert((SQLException)e.getCause(), String.format(Locale.ROOT, "Error binding JDBC value relative to `%s`", this.modelPart.getNavigableRole().getFullPath()));
            }
        }

        static class NestedRuntimeException
        extends RuntimeException {
            public NestedRuntimeException(SQLException cause) {
                super(cause);
            }
        }
    }

    private static class QueryParameterBindingType
    implements QueryParameterBinding {
        private final Type type;
        private final Object value;

        public QueryParameterBindingType(Object value, Type type) {
            this.type = type;
            this.value = value;
        }

        @Override
        public int bind(int index, PreparedStatement statement, SessionImplementor session) throws SQLException {
            this.type.nullSafeSet(statement, this.value, index, (SharedSessionContractImplementor)session);
            return this.type.getColumnSpan((Mapping)session.getSessionFactory());
        }
    }

    private static interface QueryParameterBinding {
        public int bind(int var1, PreparedStatement var2, SessionImplementor var3) throws SQLException;
    }

    private static class UpdateContext
    extends Update {
        private final List<QueryParameterBinding> bindings = new ArrayList<QueryParameterBinding>(0);

        public UpdateContext(SessionFactoryImplementor sessionFactory) {
            super(sessionFactory);
        }

        public List<QueryParameterBinding> getBindings() {
            return this.bindings;
        }

        public void bind(Object value, Type type) {
            this.bindings.add(new QueryParameterBindingType(value, type));
        }

        public void bind(Object value, ModelPart part) {
            this.bindings.add(new QueryParameterBindingPart(value, part));
        }
    }
}

