/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.field.ContentDispositionField;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.stream.Field;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInputImpl;
import org.jboss.resteasy.plugins.providers.multipart.i18n.Messages;

public class MultipartFormDataInputImpl
extends MultipartInputImpl
implements MultipartFormDataInput {
    protected Map<String, List<InputPart>> formDataMap;

    public MultipartFormDataInputImpl(MediaType contentType, Providers workers) {
        super(contentType, workers);
    }

    public MultipartFormDataInputImpl(Multipart multipart, Providers workers) throws IOException {
        super(multipart, workers);
    }

    @Override
    public Map<String, List<InputPart>> getFormDataMap() {
        if (this.formDataMap == null) {
            this.formDataMap = new LinkedHashMap<String, List<InputPart>>();
        }
        return this.formDataMap;
    }

    @Override
    public <T> T getFormDataPart(String key, Class<T> rawType, Type genericType) throws IOException {
        List<InputPart> list = this.getFormDataMap().get(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        InputPart part = list.get(0);
        if (part == null) {
            return null;
        }
        return part.getBody(rawType, genericType);
    }

    @Override
    public <T> T getFormDataPart(String key, GenericType<T> type) throws IOException {
        List<InputPart> list = this.getFormDataMap().get(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        InputPart part = list.get(0);
        if (part == null) {
            return null;
        }
        return part.getBody(type);
    }

    @Override
    protected InputPart extractPart(BodyPart bodyPart) throws IOException {
        List<InputPart> list;
        InputPart currPart = super.extractPart(bodyPart);
        Field disposition = bodyPart.getHeader().getField("Content-Disposition");
        if (disposition == null) {
            throw new RuntimeException(Messages.MESSAGES.couldFindNoContentDispositionHeader());
        }
        if (disposition instanceof ContentDispositionField) {
            String name = ((ContentDispositionField)disposition).getParameter("name");
            list = this.getFormDataMap().get(name);
            if (list == null) {
                list = new LinkedList<InputPart>();
                this.getFormDataMap().put(name, list);
            }
        } else {
            throw new RuntimeException(Messages.MESSAGES.couldNotParseContentDisposition(disposition));
        }
        list.add(currPart);
        return currPart;
    }

    List<EntityPart> toEntityParts() {
        ArrayList<EntityPart> result = new ArrayList<EntityPart>();
        for (Map.Entry<String, List<InputPart>> entry : this.getFormDataMap().entrySet()) {
            String name = entry.getKey();
            for (InputPart part : entry.getValue()) {
                result.add(new InputPartEntityPart(name, part));
            }
        }
        return result;
    }

    private static class InputPartEntityPart
    implements EntityPart {
        private final AtomicBoolean contentRetrieved = new AtomicBoolean(false);
        private final String name;
        private final InputPart inputPart;

        private InputPartEntityPart(String name, InputPart inputPart) {
            this.name = name;
            this.inputPart = inputPart;
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getFileName() {
            return Optional.ofNullable(this.inputPart.getFileName());
        }

        public InputStream getContent() {
            this.contentRetrieved.set(true);
            try {
                return this.inputPart.getBody();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public <T> T getContent(Class<T> type) throws IllegalArgumentException, IllegalStateException, IOException, WebApplicationException {
            this.checkContentRetrieved();
            return this.inputPart.getBody(new GenericType(type));
        }

        public <T> T getContent(GenericType<T> type) throws IllegalArgumentException, IllegalStateException, IOException, WebApplicationException {
            this.checkContentRetrieved();
            return this.inputPart.getBody(type);
        }

        public MultivaluedMap<String, String> getHeaders() {
            return this.inputPart.getHeaders();
        }

        public MediaType getMediaType() {
            return this.inputPart.getMediaType();
        }

        private void checkContentRetrieved() {
            if (!this.contentRetrieved.compareAndSet(false, true)) {
                throw Messages.MESSAGES.getContentAlreadyInvoked();
            }
        }
    }
}

