/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.junit;

import org.junit.runners.model.Statement;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.MockitoSession;
import org.mockito.internal.session.MockitoSessionLoggerAdapter;
import org.mockito.plugins.MockitoLogger;
import org.mockito.quality.Strictness;

class JUnitSessionStore {
    private final MockitoLogger logger;
    private MockitoSession session;
    protected Strictness strictness;

    JUnitSessionStore(MockitoLogger logger, Strictness strictness) {
        this.logger = logger;
        this.strictness = strictness;
    }

    Statement createStatement(final Statement base, final String methodName, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                AutoCloseable closeable;
                if (JUnitSessionStore.this.session == null) {
                    JUnitSessionStore.this.session = Mockito.mockitoSession().name(methodName).strictness(JUnitSessionStore.this.strictness).logger(new MockitoSessionLoggerAdapter(JUnitSessionStore.this.logger)).initMocks(target).startMocking();
                    closeable = null;
                } else {
                    closeable = MockitoAnnotations.openMocks(target);
                }
                Throwable testFailure = this.evaluateSafely(base);
                JUnitSessionStore.this.session.finishMocking(testFailure);
                if (closeable != null) {
                    closeable.close();
                }
                if (testFailure != null) {
                    throw testFailure;
                }
            }

            private Throwable evaluateSafely(Statement base2) {
                try {
                    base2.evaluate();
                    return null;
                }
                catch (Throwable throwable) {
                    return throwable;
                }
            }
        };
    }

    void setStrictness(Strictness strictness) {
        this.strictness = strictness;
        if (this.session != null) {
            this.session.setStrictness(strictness);
        }
    }
}

