/*
 * Decompiled with CFR 0.152.
 */
package kamon.metric;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import kamon.metric.Distribution;
import kamon.metric.DynamicRange;
import kamon.metric.Instrument;
import kamon.metric.Instrument$Type$;
import kamon.metric.MeasurementUnit;
import kamon.metric.MeasurementUnit$;
import kamon.metric.Metric;
import kamon.metric.MetricFactory;
import kamon.metric.MetricFactory$;
import kamon.metric.MetricSnapshot;
import kamon.metric.PeriodSnapshot;
import kamon.status.Status;
import kamon.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\t-g\u0001B\u0012%\u0001%B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!)\u0011\t\u0001C\u0001\u0005\"9q\t\u0001b\u0001\n\u0013A\u0005BB)\u0001A\u0003%\u0011\nC\u0004S\u0001\t\u0007I\u0011B*\t\r]\u0004\u0001\u0015!\u0003U\u0011%\tY\u0001\u0001a\u0001\n\u0013\ti\u0001C\u0005\u0002 \u0001\u0001\r\u0011\"\u0003\u0002\"!A\u0011Q\u0006\u0001!B\u0013\ty\u0001C\u0005\u00028\u0001\u0001\r\u0011\"\u0003\u0002:!I\u0011Q\n\u0001A\u0002\u0013%\u0011q\n\u0005\t\u0003'\u0002\u0001\u0015)\u0003\u0002<!I\u0011q\u000b\u0001A\u0002\u0013%\u0011\u0011\f\u0005\n\u0003C\u0002\u0001\u0019!C\u0005\u0003GB\u0001\"a\u001a\u0001A\u0003&\u00111\f\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!a+\u0001\t\u0003\ti\u000bC\u0004\u0002J\u0002!\t!a3\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\"9\u0011q\u001e\u0001\u0005\u0002\u0005E\bbBA|\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000bAqA!\u0011\u0001\t\u0013\u0011\u0019\u0005C\u0004\u0003X\u0001!IA!\u0017\t\u000f\tE\u0004\u0001\"\u0003\u0003t!9!Q\u0010\u0001\u0005\n\t}\u0004b\u0002BE\u0001\u0011%!1\u0012\u0005\b\u0005+\u0003A\u0011\u0002BL\u0011\u001d\u0011\t\u000b\u0001C\u0001\u0005GCqA!.\u0001\t\u0003\u00119\fC\u0004\u0003J\u0002!\tA!\u0001\u0003\u001d5+GO]5d%\u0016<\u0017n\u001d;ss*\u0011QEJ\u0001\u0007[\u0016$(/[2\u000b\u0003\u001d\nQa[1n_:\u001c\u0001a\u0005\u0002\u0001UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\faaY8oM&<\u0007C\u0001\u001a9\u001b\u0005\u0019$B\u0001\u00195\u0015\t)d'\u0001\u0005usB,7/\u00194f\u0015\u00059\u0014aA2p[&\u0011\u0011h\r\u0002\u0007\u0007>tg-[4\u0002\u000b\rdwnY6\u0011\u0005qzT\"A\u001f\u000b\u0005y2\u0013\u0001B;uS2L!\u0001Q\u001f\u0003\u000b\rcwnY6\u0002\rqJg.\u001b;?)\r\u0019UI\u0012\t\u0003\t\u0002i\u0011\u0001\n\u0005\u0006a\r\u0001\r!\r\u0005\u0006u\r\u0001\raO\u0001\b?2|wmZ3s+\u0005I\u0005C\u0001&P\u001b\u0005Y%B\u0001'N\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005q\u0015aA8sO&\u0011\u0001k\u0013\u0002\u0007\u0019><w-\u001a:\u0002\u0011}cwnZ4fe\u0002\n\u0001bX7fiJL7m]\u000b\u0002)B!QK\u0017/h\u001b\u00051&BA,Y\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u000332\n!bY8mY\u0016\u001cG/[8o\u0013\tYfKA\u0004Ue&,W*\u00199\u0011\u0005u#gB\u00010c!\tyF&D\u0001a\u0015\t\t\u0007&\u0001\u0004=e>|GOP\u0005\u0003G2\na\u0001\u0015:fI\u00164\u0017BA3g\u0005\u0019\u0019FO]5oO*\u00111\r\f\u0019\u0007QV\f\t!a\u0002\u0011\r%\u00048o`A\u0003\u001d\tQgN\u0004\u0002l[:\u0011q\f\\\u0005\u0002O%\u0011QEJ\u0005\u0003_\u0012\na!T3ue&\u001c\u0017BA9s\u0005)\u0011\u0015m]3NKR\u0014\u0018n\u0019\u0006\u0003_\u0012\u0002\"\u0001^;\r\u0001\u0011IaoBA\u0001\u0002\u0003\u0015\t\u0001\u001f\u0002\u0004?\u0012\n\u0014!C0nKR\u0014\u0018nY:!#\tIH\u0010\u0005\u0002,u&\u00111\u0010\f\u0002\b\u001d>$\b.\u001b8h!\tYS0\u0003\u0002\u007fY\t\u0019\u0011I\\=\u0011\u0007Q\f\t\u0001\u0002\u0006\u0002\u0004\u001d\t\t\u0011!A\u0003\u0002a\u00141a\u0018\u00133!\r!\u0018q\u0001\u0003\u000b\u0003\u00139\u0011\u0011!A\u0001\u0006\u0003A(aA0%g\u0005!r\f\\1tiNs\u0017\r]:i_RLen\u001d;b]R,\"!a\u0004\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005!A/[7f\u0015\t\tI\"\u0001\u0003kCZ\f\u0017\u0002BA\u000f\u0003'\u0011q!\u00138ti\u0006tG/\u0001\r`Y\u0006\u001cHo\u00158baNDw\u000e^%ogR\fg\u000e^0%KF$B!a\t\u0002*A\u00191&!\n\n\u0007\u0005\u001dBF\u0001\u0003V]&$\b\"CA\u0016\u0013\u0005\u0005\t\u0019AA\b\u0003\rAH%M\u0001\u0016?2\f7\u000f^*oCB\u001c\bn\u001c;J]N$\u0018M\u001c;!Q\rQ\u0011\u0011\u0007\t\u0004W\u0005M\u0012bAA\u001bY\tAao\u001c7bi&dW-\u0001\u0006`g\u000eDW\rZ;mKJ,\"!a\u000f\u0011\u000b-\ni$!\u0011\n\u0007\u0005}BF\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019q+a\u0012\u000b\u0007y\n9\"\u0003\u0003\u0002L\u0005\u0015#\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006qql]2iK\u0012,H.\u001a:`I\u0015\fH\u0003BA\u0012\u0003#B\u0011\"a\u000b\r\u0003\u0003\u0005\r!a\u000f\u0002\u0017}\u001b8\r[3ek2,'\u000f\t\u0015\u0004\u001b\u0005E\u0012\u0001C0gC\u000e$xN]=\u0016\u0005\u0005m\u0003c\u0001#\u0002^%\u0019\u0011q\f\u0013\u0003\u001b5+GO]5d\r\u0006\u001cGo\u001c:z\u00031yf-Y2u_JLx\fJ3r)\u0011\t\u0019#!\u001a\t\u0013\u0005-r\"!AA\u0002\u0005m\u0013!C0gC\u000e$xN]=!Q\r\u0001\u0012\u0011G\u0001\bG>,h\u000e^3s))\ty'a\u001e\u0002|\u0005\u0005\u0015Q\u0012\t\u0005\u0003c\n\u0019H\u0004\u0002E]&\u0019\u0011Q\u000f:\u0003\u000f\r{WO\u001c;fe\"1\u0011\u0011P\tA\u0002q\u000bAA\\1nK\"9\u0011QP\tA\u0002\u0005}\u0014a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004BaKA\u001f9\"9\u00111Q\tA\u0002\u0005\u0015\u0015\u0001B;oSR\u0004RaKA\u001f\u0003\u000f\u00032\u0001RAE\u0013\r\tY\t\n\u0002\u0010\u001b\u0016\f7/\u001e:f[\u0016tG/\u00168ji\"9\u0011qR\tA\u0002\u0005E\u0015AE1vi>,\u0006\u000fZ1uK&sG/\u001a:wC2\u0004RaKA\u001f\u0003'\u0003B!!\u0005\u0002\u0016&!\u0011qSA\n\u0005!!UO]1uS>t\u0017!B4bk\u001e,GCCAO\u0003G\u000b)+a*\u0002*B!\u0011\u0011OAP\u0013\r\t\tK\u001d\u0002\u0006\u000f\u0006,x-\u001a\u0005\u0007\u0003s\u0012\u0002\u0019\u0001/\t\u000f\u0005u$\u00031\u0001\u0002\u0000!9\u00111\u0011\nA\u0002\u0005\u0015\u0005bBAH%\u0001\u0007\u0011\u0011S\u0001\nQ&\u001cHo\\4sC6$B\"a,\u00026\u0006]\u0016\u0011XA^\u0003\u000f\u0004B!!\u001d\u00022&\u0019\u00111\u0017:\u0003\u0013!K7\u000f^8he\u0006l\u0007BBA='\u0001\u0007A\fC\u0004\u0002~M\u0001\r!a \t\u000f\u0005\r5\u00031\u0001\u0002\u0006\"9\u0011QX\nA\u0002\u0005}\u0016\u0001\u00043z]\u0006l\u0017n\u0019*b]\u001e,\u0007#B\u0016\u0002>\u0005\u0005\u0007c\u0001#\u0002D&\u0019\u0011Q\u0019\u0013\u0003\u0019\u0011Kh.Y7jGJ\u000bgnZ3\t\u000f\u0005=5\u00031\u0001\u0002\u0012\u0006)A/[7feRQ\u0011QZAj\u0003+\f9.!7\u0011\t\u0005E\u0014qZ\u0005\u0004\u0003#\u0014(!\u0002+j[\u0016\u0014\bBBA=)\u0001\u0007A\fC\u0004\u0002~Q\u0001\r!a \t\u000f\u0005uF\u00031\u0001\u0002@\"9\u0011q\u0012\u000bA\u0002\u0005E\u0015\u0001\u0004:b]\u001e,7+Y7qY\u0016\u0014H\u0003DAp\u0003K\f9/!;\u0002l\u00065\b\u0003BA9\u0003CL1!a9s\u00051\u0011\u0016M\\4f'\u0006l\u0007\u000f\\3s\u0011\u0019\tI(\u0006a\u00019\"9\u0011QP\u000bA\u0002\u0005}\u0004bBAB+\u0001\u0007\u0011Q\u0011\u0005\b\u0003{+\u0002\u0019AA`\u0011\u001d\ty)\u0006a\u0001\u0003#\u000b1B]3d_:4\u0017nZ;sKR!\u00111EAz\u0011\u0019\t)P\u0006a\u0001c\u0005Ia.Z<D_:4\u0017nZ\u0001\u000eE&tGmU2iK\u0012,H.\u001a:\u0015\t\u0005\r\u00121 \u0005\b\u0003{<\u0002\u0019AA!\u0003%\u00198\r[3ek2,'/\u0001\u0005tQV$Hm\\<o)\t\t\u0019#\u0001\fwC2LG-\u0019;f\u0013:\u001cHO];nK:$H+\u001f9f+\u0011\u00119A!\u0004\u0015\t\t%!Q\u0005\u000b\u0007\u0005\u0017\u0011\tBa\u0005\u0011\u0007Q\u0014i\u0001\u0002\u0004\u0003\u0010e\u0011\r\u0001\u001f\u0002\u0002)\"1\u0011\u0011P\rA\u0002qCqA!\u0006\u001a\u0001\u0004\u00119\"\u0001\bj]N$(/^7f]R$\u0016\u0010]3\u0011\t\te!q\u0004\b\u0004\t\nm\u0011b\u0001B\u000fI\u0005Q\u0011J\\:ueVlWM\u001c;\n\t\t\u0005\"1\u0005\u0002\u0005)f\u0004XMC\u0002\u0003\u001e\u0011Bq!J\r\u0005\u0002\u0004\u00119\u0003E\u0003,\u0005S\u0011i#C\u0002\u0003,1\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0019\u0007\u0005_\u00119D!\u0010\u0011\u000f\u0011\u0013\tD!\u000e\u0003<%\u0019!1\u0007\u0013\u0003\r5+GO]5d!\r!(q\u0007\u0003\f\u0005s\u0011)#!A\u0001\u0002\u000b\u0005\u0001PA\u0002`IQ\u00022\u0001\u001eB\u001f\t-\u0011yD!\n\u0002\u0002\u0003\u0005)\u0011\u0001=\u0003\u0007}#S'\u0001\nj[BdW-\\3oi\u0006$\u0018n\u001c8OC6,Gc\u0001/\u0003F!1QE\u0007a\u0001\u0005\u000f\u0002dA!\u0013\u0003N\tM\u0003c\u0002#\u00032\t-#\u0011\u000b\t\u0004i\n5Ca\u0003B(\u0005\u000b\n\t\u0011!A\u0003\u0002a\u00141a\u0018\u00137!\r!(1\u000b\u0003\f\u0005+\u0012)%!A\u0001\u0002\u000b\u0005\u0001PA\u0002`I]\n1c\u00195fG.Len\u001d;sk6,g\u000e\u001e+za\u0016$\u0002\"a\t\u0003\\\tu#q\f\u0005\u0007\u0003sZ\u0002\u0019\u0001/\t\u000f\tU1\u00041\u0001\u0003\u0018!1Qe\u0007a\u0001\u0005C\u0002dAa\u0019\u0003h\t5\u0004c\u0002#\u00032\t\u0015$1\u000e\t\u0004i\n\u001dDa\u0003B5\u0005?\n\t\u0011!A\u0003\u0002a\u00141a\u0018\u00139!\r!(Q\u000e\u0003\f\u0005_\u0012y&!A\u0001\u0002\u000b\u0005\u0001PA\u0002`Ie\n\u0001c\u00195fG.$Um]2sSB$\u0018n\u001c8\u0015\u0011\u0005\r\"Q\u000fB<\u0005sBa!!\u001f\u001d\u0001\u0004a\u0006BBA?9\u0001\u0007A\fC\u0004\u0003|q\u0001\r!a \u0002'A\u0014xN^5eK\u0012$Um]2sSB$\u0018n\u001c8\u0002\u0013\rDWmY6V]&$H\u0003CA\u0012\u0005\u0003\u0013\u0019I!\"\t\r\u0005eT\u00041\u0001]\u0011\u001d\t\u0019)\ba\u0001\u0003\u000fCqAa\"\u001e\u0001\u0004\t))\u0001\u0007qe>4\u0018\u000eZ3e+:LG/A\bdQ\u0016\u001c7.Q;u_V\u0003H-\u0019;f)!\t\u0019C!$\u0003\u0010\nE\u0005BBA==\u0001\u0007A\fC\u0004\u0002\u0010z\u0001\r!a%\t\u000f\tMe\u00041\u0001\u0002\u0012\u0006Q\u0002O]8wS\u0012,G-Q;u_V\u0003H-\u0019;f\u0013:$XM\u001d<bY\u0006\t2\r[3dW\u0012Kh.Y7jGJ\u000bgnZ3\u0015\u0011\u0005\r\"\u0011\u0014BN\u0005;Ca!!\u001f \u0001\u0004a\u0006bBA_?\u0001\u0007\u0011\u0011\u0019\u0005\b\u0005?{\u0002\u0019AA`\u0003Q\u0001(o\u001c<jI\u0016$G)\u001f8b[&\u001c'+\u00198hK\u0006A1O\\1qg\"|G\u000f\u0006\u0003\u0003&\n-\u0006c\u0001#\u0003(&\u0019!\u0011\u0016\u0013\u0003\u001dA+'/[8e':\f\u0007o\u001d5pi\"9!Q\u0016\u0011A\u0002\t=\u0016A\u0003:fg\u0016$8\u000b^1uKB\u00191F!-\n\u0007\tMFFA\u0004C_>dW-\u00198\u0002\rM$\u0018\r^;t)\t\u0011I\f\u0005\u0003\u0003<\n\u0015g\u0002\u0002B_\u0005\u0003l!Aa0\u000b\u0007\tUf%\u0003\u0003\u0003D\n}\u0016AB*uCR,8/C\u0002$\u0005\u000fTAAa1\u0003@\u0006)1\r\\3be\u0002")
public class MetricRegistry {
    private final Config config;
    private final Clock clock;
    private final Logger _logger;
    private final TrieMap<String, Metric.BaseMetric<?, ?, ?>> _metrics;
    private volatile Instant _lastSnapshotInstant;
    private volatile Option<ScheduledExecutorService> _scheduler;
    private volatile MetricFactory _factory;

    private Logger _logger() {
        return this._logger;
    }

    private TrieMap<String, Metric.BaseMetric<?, ?, ?>> _metrics() {
        return this._metrics;
    }

    private Instant _lastSnapshotInstant() {
        return this._lastSnapshotInstant;
    }

    private void _lastSnapshotInstant_$eq(Instant x$1) {
        this._lastSnapshotInstant = x$1;
    }

    private Option<ScheduledExecutorService> _scheduler() {
        return this._scheduler;
    }

    private void _scheduler_$eq(Option<ScheduledExecutorService> x$1) {
        this._scheduler = x$1;
    }

    private MetricFactory _factory() {
        return this._factory;
    }

    private void _factory_$eq(MetricFactory x$1) {
        this._factory = x$1;
    }

    public Metric.Counter counter(String name, Option<String> description, Option<MeasurementUnit> unit, Option<Duration> autoUpdateInterval) {
        Metric.Counter metric = (Metric.Counter)this.validateInstrumentType((Function0 & Serializable)() -> (Metric.BaseMetric)this._metrics().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> this._factory().counter(name, description, unit, autoUpdateInterval)), name, Instrument$Type$.MODULE$.Counter());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkUnit(metric.name(), ((Metric.Settings.ForValueInstrument)metric.settings()).unit(), unit);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForValueInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public Metric.Gauge gauge(String name, Option<String> description, Option<MeasurementUnit> unit, Option<Duration> autoUpdateInterval) {
        Metric.Gauge metric = (Metric.Gauge)this.validateInstrumentType((Function0 & Serializable)() -> (Metric.BaseMetric)this._metrics().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> this._factory().gauge(name, description, unit, autoUpdateInterval)), name, Instrument$Type$.MODULE$.Gauge());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkUnit(metric.name(), ((Metric.Settings.ForValueInstrument)metric.settings()).unit(), unit);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForValueInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public Metric.Histogram histogram(String name, Option<String> description, Option<MeasurementUnit> unit, Option<DynamicRange> dynamicRange, Option<Duration> autoUpdateInterval) {
        Metric.Histogram metric = (Metric.Histogram)this.validateInstrumentType((Function0 & Serializable)() -> (Metric.BaseMetric)this._metrics().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> this._factory().histogram(name, description, unit, dynamicRange, autoUpdateInterval)), name, Instrument$Type$.MODULE$.Histogram());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkUnit(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit(), unit);
        this.checkDynamicRange(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).dynamicRange(), dynamicRange);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public Metric.Timer timer(String name, Option<String> description, Option<DynamicRange> dynamicRange, Option<Duration> autoUpdateInterval) {
        Metric.Timer metric = (Metric.Timer)this.validateInstrumentType((Function0 & Serializable)() -> (Metric.BaseMetric)this._metrics().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> this._factory().timer(name, description, (Option<MeasurementUnit>)new Some((Object)MeasurementUnit$.MODULE$.time().nanoseconds()), dynamicRange, autoUpdateInterval)), name, Instrument$Type$.MODULE$.Timer());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkDynamicRange(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).dynamicRange(), dynamicRange);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public Metric.RangeSampler rangeSampler(String name, Option<String> description, Option<MeasurementUnit> unit, Option<DynamicRange> dynamicRange, Option<Duration> autoUpdateInterval) {
        Metric.RangeSampler metric = (Metric.RangeSampler)this.validateInstrumentType((Function0 & Serializable)() -> (Metric.BaseMetric)this._metrics().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> this._factory().rangeSampler(name, description, unit, dynamicRange, autoUpdateInterval)), name, Instrument$Type$.MODULE$.RangeSampler());
        this.checkDescription(metric.name(), metric.description(), description);
        this.checkUnit(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).unit(), unit);
        this.checkDynamicRange(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).dynamicRange(), dynamicRange);
        this.checkAutoUpdate(metric.name(), ((Metric.Settings.ForDistributionInstrument)metric.settings()).autoUpdateInterval(), autoUpdateInterval);
        return metric;
    }

    public void reconfigure(Config newConfig) {
        this._factory_$eq(MetricFactory$.MODULE$.from(newConfig, this.clock, this._scheduler()));
    }

    public void bindScheduler(ScheduledExecutorService scheduler) {
        this._scheduler_$eq((Option<ScheduledExecutorService>)new Some((Object)scheduler));
        this._factory_$eq(MetricFactory$.MODULE$.from(this.config, this.clock, this._scheduler()));
        this._metrics().values().foreach((Function1 & Serializable)x$1 -> {
            x$1.bindScheduler(scheduler);
            return BoxedUnit.UNIT;
        });
    }

    public void shutdown() {
        this._scheduler_$eq((Option<ScheduledExecutorService>)None$.MODULE$);
        this._metrics().values().foreach((Function1 & Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    private <T> T validateInstrumentType(Function0<Metric<?, ?>> metric, String name, Instrument.Type instrumentType) {
        Metric lookedUpMetric = (Metric)metric.apply();
        if (!instrumentType.implementation().isInstance(lookedUpMetric)) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(50).append("Cannot redefine metric [").append(name).append("] as a [").append(instrumentType.name()).append("], it was already ").toString()).append(new StringBuilder(18).append("registered as a [").append(this.implementationName((Metric)metric.apply())).append("]").toString()).toString());
        }
        return (T)lookedUpMetric;
    }

    private String implementationName(Metric<?, ?> metric) {
        String string;
        Metric<?, ?> metric2 = metric;
        if (metric2 instanceof Metric.Counter) {
            string = Instrument$Type$.MODULE$.Counter().name();
        } else if (metric2 instanceof Metric.Gauge) {
            string = Instrument$Type$.MODULE$.Gauge().name();
        } else if (metric2 instanceof Metric.Histogram) {
            string = Instrument$Type$.MODULE$.Histogram().name();
        } else if (metric2 instanceof Metric.RangeSampler) {
            string = Instrument$Type$.MODULE$.RangeSampler().name();
        } else if (metric2 instanceof Metric.Timer) {
            string = Instrument$Type$.MODULE$.Timer().name();
        } else {
            throw new MatchError(metric2);
        }
        return string;
    }

    private void checkInstrumentType(String name, Instrument.Type instrumentType, Metric<?, ?> metric) {
        if (!instrumentType.implementation().isInstance(metric)) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(68).append("Cannot redefine metric [").append(name).append("] as a [").append(instrumentType.name()).append("], it was already registered as a [").append(metric.getClass().getName()).append("]").toString());
        }
    }

    private void checkDescription(String name, String description, Option<String> providedDescription) {
        block0: {
            if (!providedDescription.exists((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)MetricRegistry.$anonfun$checkDescription$1(description, d)))) break block0;
            this._logger().warn(new StringBuilder(41).append("Ignoring new description [").append(providedDescription.getOrElse((Function0 & Serializable)() -> "")).append("] for metric [").append(name).append("]").toString());
        }
    }

    private void checkUnit(String name, MeasurementUnit unit, Option<MeasurementUnit> providedUnit) {
        block0: {
            if (!providedUnit.exists((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)MetricRegistry.$anonfun$checkUnit$1(unit, u)))) break block0;
            this._logger().warn(new StringBuilder(34).append("Ignoring new unit [").append(providedUnit.getOrElse((Function0 & Serializable)() -> "")).append("] for metric [").append(name).append("]").toString());
        }
    }

    private void checkAutoUpdate(String name, Duration autoUpdateInterval, Option<Duration> providedAutoUpdateInterval) {
        block0: {
            if (!providedAutoUpdateInterval.exists((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)MetricRegistry.$anonfun$checkAutoUpdate$1(autoUpdateInterval, u)))) break block0;
            this._logger().warn(new StringBuilder(50).append("Ignoring new auto-update interval [").append(providedAutoUpdateInterval.getOrElse((Function0 & Serializable)() -> "")).append("] for metric [").append(name).append("]").toString());
        }
    }

    private void checkDynamicRange(String name, DynamicRange dynamicRange, Option<DynamicRange> providedDynamicRange) {
        block0: {
            if (!providedDynamicRange.exists((Function1 & Serializable)dr -> BoxesRunTime.boxToBoolean((boolean)MetricRegistry.$anonfun$checkDynamicRange$1(dynamicRange, dr)))) break block0;
            this._logger().warn(new StringBuilder(43).append("Ignoring new dynamic range [").append(providedDynamicRange.getOrElse((Function0 & Serializable)() -> "")).append("] for metric [").append(name).append("]").toString());
        }
    }

    public synchronized PeriodSnapshot snapshot(boolean resetState) {
        ObjectRef counters = ObjectRef.create((Object)package$.MODULE$.List().empty());
        ObjectRef gauges = ObjectRef.create((Object)package$.MODULE$.List().empty());
        ObjectRef histograms = ObjectRef.create((Object)package$.MODULE$.List().empty());
        ObjectRef timers = ObjectRef.create((Object)package$.MODULE$.List().empty());
        ObjectRef rangeSamplers = ObjectRef.create((Object)package$.MODULE$.List().empty());
        this._metrics().foreach((Function1 & Serializable)x0$1 -> {
            MetricRegistry.$anonfun$snapshot$1(counters, resetState, gauges, histograms, timers, rangeSamplers, x0$1);
            return BoxedUnit.UNIT;
        });
        Instant periodStart = this._lastSnapshotInstant();
        Instant periodEnd = this.clock.instant();
        this._lastSnapshotInstant_$eq(periodEnd);
        return new PeriodSnapshot(periodStart, periodEnd, (Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>>)((List)counters.elem), (Seq<MetricSnapshot<Metric.Settings.ForValueInstrument, Object>>)((List)gauges.elem), (Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>>)((List)histograms.elem), (Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>>)((List)timers.elem), (Seq<MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>>)((List)rangeSamplers.elem));
    }

    public Status.MetricRegistry status() {
        return new Status.MetricRegistry((Seq<Status.Metric>)((IterableOnceOps)this._metrics().values().map((Function1 & Serializable)x$3 -> x$3.status())).toSeq());
    }

    public void clear() {
        this._metrics().values().foreach((Function1 & Serializable)metric -> {
            metric.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkDescription$1(String description$6, String d) {
        String string = d;
        String string2 = description$6;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$checkUnit$1(MeasurementUnit unit$5, MeasurementUnit u) {
        MeasurementUnit measurementUnit = u;
        MeasurementUnit measurementUnit2 = unit$5;
        return measurementUnit == null ? measurementUnit2 != null : !((Object)measurementUnit).equals(measurementUnit2);
    }

    public static final /* synthetic */ boolean $anonfun$checkAutoUpdate$1(Duration autoUpdateInterval$6, Duration u) {
        Duration duration = u;
        Duration duration2 = autoUpdateInterval$6;
        return duration == null ? duration2 != null : !((Object)duration).equals(duration2);
    }

    public static final /* synthetic */ boolean $anonfun$checkDynamicRange$1(DynamicRange dynamicRange$4, DynamicRange dr) {
        DynamicRange dynamicRange = dr;
        DynamicRange dynamicRange2 = dynamicRange$4;
        return dynamicRange == null ? dynamicRange2 != null : !((Object)dynamicRange).equals(dynamicRange2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$snapshot$1(ObjectRef counters$1, boolean resetState$1, ObjectRef gauges$1, ObjectRef histograms$1, ObjectRef timers$1, ObjectRef rangeSamplers$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Metric.BaseMetric metric = (Metric.BaseMetric)tuple2._2();
        Metric.BaseMetric baseMetric = metric;
        if (baseMetric instanceof Metric.Counter) {
            Metric.BaseMetric baseMetric2 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric2.snapshot(resetState$1);
            counters$1.elem = ((List)counters$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseMetric instanceof Metric.Gauge) {
            Metric.BaseMetric baseMetric3 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric3.snapshot(resetState$1);
            gauges$1.elem = ((List)gauges$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseMetric instanceof Metric.Histogram) {
            Metric.BaseMetric baseMetric4 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric4.snapshot(resetState$1);
            histograms$1.elem = ((List)histograms$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (baseMetric instanceof Metric.Timer) {
            Metric.BaseMetric baseMetric5 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric5.snapshot(resetState$1);
            timers$1.elem = ((List)timers$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(baseMetric instanceof Metric.RangeSampler)) throw new MatchError((Object)baseMetric);
            Metric.BaseMetric baseMetric6 = baseMetric;
            MetricSnapshot metricSnapshot = baseMetric6.snapshot(resetState$1);
            rangeSamplers$1.elem = ((List)rangeSamplers$1.elem).$colon$colon(metricSnapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public MetricRegistry(Config config, Clock clock) {
        this.config = config;
        this.clock = clock;
        this._logger = LoggerFactory.getLogger(MetricRegistry.class);
        this._metrics = TrieMap$.MODULE$.empty();
        this._lastSnapshotInstant = clock.instant();
        this._scheduler = None$.MODULE$;
        this._factory = MetricFactory$.MODULE$.from(config, clock, this._scheduler());
    }
}

