/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.auth.config;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.core.util.TokenGenerator$;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.deployit.security.model.Tokens;
import com.xebialabs.deployit.security.model.XldUserToken;
import com.xebialabs.deployit.security.service.UserTokenService;
import com.xebialabs.xldeploy.auth.TokenExpiredException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.stereotype.Component;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component(value="xlAuthenticationProvider")
@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001\u0002\t\u0012\u0001qA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\ts\u0001\u0011\t\u0011)A\u0005u!)\u0001\t\u0001C\u0001\u0003\"9a\t\u0001b\u0001\n\u00139\u0005B\u0002(\u0001A\u0003%\u0001\nC\u0004P\u0001\u0001\u0007I\u0011\u0002)\t\u000fm\u0003\u0001\u0019!C\u00059\"1Q\r\u0001Q!\nECQA\u001a\u0001\u0005B\u001dDQA\u001c\u0001\u0005\n=DQ\u0001 \u0001\u0005\nuDq!!\u0002\u0001\t\u0003\n9\u0001C\u0004\u00020\u0001!I!!\r\t\r\u0005E\u0003\u0001\"\u0001Q\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\u0012A\u0004R3qY>L\u0018)\u001e;iK:$\u0018nY1uS>t\u0007K]8wS\u0012,'O\u0003\u0002\u0013'\u000511m\u001c8gS\u001eT!\u0001F\u000b\u0002\t\u0005,H\u000f\u001b\u0006\u0003-]\t\u0001\u0002\u001f7eKBdw.\u001f\u0006\u00031e\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003i\t1aY8n\u0007\u0001\u00192\u0001A\u000f&!\tq2%D\u0001 \u0015\t\u0001\u0013%\u0001\u0003mC:<'\"\u0001\u0012\u0002\t)\fg/Y\u0005\u0003I}\u0011aa\u00142kK\u000e$\bC\u0001\u00140\u001b\u00059#B\u0001\u0015*\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!AK\u0016\u0002\u0011M,7-\u001e:jifT!\u0001L\u0017\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AL\u0001\u0004_J<\u0017B\u0001\u0019(\u0005Y\tU\u000f\u001e5f]RL7-\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\u0018aC;tKJ\u001cVM\u001d<jG\u0016\u0004\"aM\u001c\u000e\u0003QR!AK\u001b\u000b\u0005Y:\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005a\"$aC+tKJ\u001cVM\u001d<jG\u0016\f\u0001#^:feR{7.\u001a8TKJ4\u0018nY3\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\"\u0014aB:feZL7-Z\u0005\u0003\u007fq\u0012\u0001#V:feR{7.\u001a8TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\r\u0011E)\u0012\t\u0003\u0007\u0002i\u0011!\u0005\u0005\u0006c\r\u0001\rA\r\u0005\u0006s\r\u0001\rAO\u0001\u0007Y><w-\u001a:\u0016\u0003!\u0003\"!\u0013'\u000e\u0003)S!aS\u0017\u0002\u000bMdg\r\u000e6\n\u00055S%A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002#\u0005,H\u000f[8sSRLWm]'baB,'/F\u0001R!\t\u0011\u0016,D\u0001T\u0015\t!V+A\u0004nCB\u0004\u0018N\\4\u000b\u0005Y;\u0016!C1vi\"|'/\u001b;z\u0015\tA\u0016&\u0001\u0003d_J,\u0017B\u0001.T\u0005a9%/\u00198uK\u0012\fU\u000f\u001e5pe&$\u0018.Z:NCB\u0004XM]\u0001\u0016CV$\bn\u001c:ji&,7/T1qa\u0016\u0014x\fJ3r)\ti6\r\u0005\u0002_C6\tqLC\u0001a\u0003\u0015\u00198-\u00197b\u0013\t\u0011wL\u0001\u0003V]&$\bb\u00023\b\u0003\u0003\u0005\r!U\u0001\u0004q\u0012\n\u0014AE1vi\"|'/\u001b;jKNl\u0015\r\u001d9fe\u0002\nA\"Y;uQ\u0016tG/[2bi\u0016$\"\u0001\u001b7\u0011\u0005%TW\"A,\n\u0005-<&AD!vi\",g\u000e^5dCRLwN\u001c\u0005\u0006[&\u0001\r\u0001[\u0001\u0006i>\\WM\\\u0001\u001aCV$\b.\u001a8uS\u000e\fG/\u001a$s_6,6/\u001a:U_.,g\u000e\u0006\u0002ia\")QN\u0003a\u0001cB\u0011!/\u001f\b\u0003g^\u0004\"\u0001^0\u000e\u0003UT!A^\u000e\u0002\rq\u0012xn\u001c;?\u0013\tAx,\u0001\u0004Qe\u0016$WMZ\u0005\u0003un\u0014aa\u0015;sS:<'B\u0001=`\u0003m\tW\u000f\u001e5f]RL7-\u0019;f\rJ|Wn\u0011:fI\u0016tG/[1mgR!\u0001N`A\u0001\u0011\u0015y8\u00021\u0001r\u0003!)8/\u001a:oC6,\u0007BBA\u0002\u0017\u0001\u0007\u0011/\u0001\u0005qCN\u001cxo\u001c:e\u0003!\u0019X\u000f\u001d9peR\u001cH\u0003BA\u0005\u0003\u001f\u00012AXA\u0006\u0013\r\tia\u0018\u0002\b\u0005>|G.Z1o\u0011\u0019AC\u00021\u0001\u0002\u0012A\"\u00111CA\u000f!\u0015\u0011\u0018QCA\r\u0013\r\t9b\u001f\u0002\u0006\u00072\f7o\u001d\t\u0005\u00037\ti\u0002\u0004\u0001\u0005\u0019\u0005}\u0011qBA\u0001\u0002\u0003\u0015\t!!\t\u0003\u0007}#3'\u0005\u0003\u0002$\u0005%\u0002c\u00010\u0002&%\u0019\u0011qE0\u0003\u000f9{G\u000f[5oOB\u0019a,a\u000b\n\u0007\u00055rLA\u0002B]f\f1#\u001a<bYV\fG/Z!vi\"|'/\u001b;jKN$B!a\r\u0002PA\"\u0011QGA\"!\u0019\t9$!\u0010\u0002B5\u0011\u0011\u0011\b\u0006\u0004\u0003w\t\u0013\u0001B;uS2LA!a\u0010\u0002:\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\t\u0005m\u00111\t\u0003\f\u0003\u000bj\u0011\u0011!A\u0001\u0006\u0003\t9EA\u0002`IQ\nB!a\t\u0002JA\u0019\u0011.a\u0013\n\u0007\u00055sK\u0001\tHe\u0006tG/\u001a3BkRDwN]5us\")q0\u0004a\u0001c\u0006!r-\u001a;BkRDwN]5uS\u0016\u001cX*\u00199qKJ\fAc]3u\u0003V$\bn\u001c:ji&,7/T1qa\u0016\u0014HcA/\u0002X!)qj\u0004a\u0001#\":\u0001!a\u0017\u0002h\u0005%\u0004\u0003BA/\u0003Gj!!a\u0018\u000b\u0007\u0005\u00054&\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!\u001a\u0002`\tI1i\\7q_:,g\u000e^\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003W\n\u0001\u0004\u001f7BkRDWM\u001c;jG\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0001")
public class DeployAuthenticationProvider
implements AuthenticationProvider {
    private final UserService userService;
    private final UserTokenService userTokenService;
    private final Logger logger;
    private GrantedAuthoritiesMapper authoritiesMapper;

    private Logger logger() {
        return this.logger;
    }

    private GrantedAuthoritiesMapper authoritiesMapper() {
        return this.authoritiesMapper;
    }

    private void authoritiesMapper_$eq(GrantedAuthoritiesMapper x$1) {
        this.authoritiesMapper = x$1;
    }

    public Authentication authenticate(Authentication token) {
        Authentication authentication;
        this.logger().debug("Authenticating for Digital.ai Deploy");
        try {
            Authentication authentication2 = token;
            authentication = authentication2 instanceof PersonalAuthenticationToken ? this.authenticateFromUserToken(token.getCredentials().toString()) : this.authenticateFromCredentials(token.getPrincipal().toString(), token.getCredentials().toString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AuthenticationFailureException ? true : throwable2 instanceof NotFoundException) {
                throw new BadCredentialsException(throwable2.getMessage(), throwable2);
            }
            throw throwable;
        }
        return authentication;
    }

    private Authentication authenticateFromUserToken(String token) {
        this.logger().trace("Authenticating using personal access token");
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        XldUserToken userToken = this.userTokenService.findByUserToken(tokenHash);
        if (userToken == null) {
            throw new AuthenticationFailureException("Cannot authenticate with supplied personal access token");
        }
        if (((Tokens)userToken.tokens().head()).isExpired()) {
            throw new TokenExpiredException("The token expired on " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(((Tokens)userToken.tokens().head()).expiryDate()));
        }
        this.userTokenService.updateLastUsedDate(Predef$.MODULE$.Integer2int(((Tokens)userToken.tokens().head()).ciId()), new Date());
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(userToken.username());
        return new PersonalAuthenticationToken((Object)userToken.username(), token, ((Tokens)userToken.tokens().head()).expiryDate(), mappedAuthorities, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    private Authentication authenticateFromCredentials(String username, String password) {
        this.logger().trace("Authenticating [" + username + "]");
        if (Strings.isBlank((String)username)) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        this.userService.authenticate(username, password);
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(username);
        return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, mappedAuthorities);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class) || authentication.isAssignableFrom(PersonalAuthenticationToken.class);
    }

    private Collection<? extends GrantedAuthority> evaluateAuthorities(String username) {
        User user = this.userService.read(username);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        Object object = user.isAdmin() || "admin".equals(user.getUsername()) ? BoxesRunTime.boxToBoolean((boolean)authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"))) : BoxedUnit.UNIT;
        return this.authoritiesMapper().mapAuthorities(authorities);
    }

    public GrantedAuthoritiesMapper getAuthoritiesMapper() {
        return this.authoritiesMapper();
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper_$eq(authoritiesMapper);
    }

    public DeployAuthenticationProvider(UserService userService, UserTokenService userTokenService) {
        this.userService = userService;
        this.userTokenService = userTokenService;
        this.logger = LoggerFactory.getLogger(DeployAuthenticationProvider.class);
        this.authoritiesMapper = new NullAuthoritiesMapper();
    }
}

