/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.listener.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.security.policy.UserGroupMembershipCreationPolicy;
import com.xebialabs.deployit.security.policy.UserProfileCreationPolicy;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0005e4AAC\u0006\u0001-!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u001d\u0019\u0006A1A\u0005\nQCaa\u0017\u0001!\u0002\u0013)\u0006\"\u0002/\u0001\t\u0003j\u0006\"\u00022\u0001\t\u0013\u0019\u0007\"\u00028\u0001\t\u0013y'AI!vi\",g\u000e^5dCRLwN\\*vG\u000e,7o]#wK:$H*[:uK:,'O\u0003\u0002\r\u001b\u0005q\u0011-\u001e;iK:$\u0018nY1uS>t'B\u0001\b\u0010\u0003!a\u0017n\u001d;f]\u0016\u0014(B\u0001\t\u0012\u0003!!W\r\u001d7ps&$(B\u0001\n\u0014\u0003%AXMY5bY\u0006\u00147OC\u0001\u0015\u0003\r\u0019w.\\\u0002\u0001'\r\u0001qc\b\t\u00031ui\u0011!\u0007\u0006\u00035m\tA\u0001\\1oO*\tA$\u0001\u0003kCZ\f\u0017B\u0001\u0010\u001a\u0005\u0019y%M[3diB\u0019\u0001eJ\u0015\u000e\u0003\u0005R!AI\u0012\u0002\u000f\r|g\u000e^3yi*\u0011A%J\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta%A\u0002pe\u001eL!\u0001K\u0011\u0003'\u0005\u0003\b\u000f\\5dCRLwN\u001c'jgR,g.\u001a:\u0011\u0005)\u0002T\"A\u0016\u000b\u00051j\u0013!B3wK:$(B\u0001\u0007/\u0015\ty3%\u0001\u0005tK\u000e,(/\u001b;z\u0013\t\t4F\u0001\u000eBkRDWM\u001c;jG\u0006$\u0018n\u001c8Tk\u000e\u001cWm]:Fm\u0016tG/A\u000evg\u0016\u0014\bK]8gS2,7I]3bi&|g\u000eU8mS\u000eLWm\u001d\t\u0004i]JT\"A\u001b\u000b\u0005YZ\u0012\u0001B;uS2L!\u0001O\u001b\u0003\t1K7\u000f\u001e\t\u0003uyj\u0011a\u000f\u0006\u0003yu\na\u0001]8mS\u000eL(BA\u0018\u0010\u0013\ty4HA\rVg\u0016\u0014\bK]8gS2,7I]3bi&|g\u000eU8mS\u000eL\u0018aI;tKJ<%o\\;q\u001b\u0016l'-\u001a:tQ&\u00048I]3bi&|g\u000eU8mS\u000eLWm\u001d\t\u0004i]\u0012\u0005C\u0001\u001eD\u0013\t!5HA\u0011Vg\u0016\u0014xI]8va6+WNY3sg\"L\u0007o\u0011:fCRLwN\u001c)pY&\u001c\u00170\u0001\u0004=S:LGO\u0010\u000b\u0004\u000f&S\u0005C\u0001%\u0001\u001b\u0005Y\u0001\"\u0002\u001a\u0004\u0001\u0004\u0019\u0004\"\u0002!\u0004\u0001\u0004\t\u0015AF:vaB|'\u000f^:Bgft7-\u0012=fGV$\u0018n\u001c8\u0015\u00035\u0003\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013qAQ8pY\u0016\fg.\u0001\u0004m_\u001e<WM]\u000b\u0002+B\u0011a+W\u0007\u0002/*\u0011\u0001,J\u0001\u0006g24GG[\u0005\u00035^\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0013_:\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Fm\u0016tG\u000f\u0006\u0002_CB\u0011ajX\u0005\u0003A>\u0013A!\u00168ji\")Af\u0002a\u0001S\u0005\u0001c-\u001b8e\u0003B\u0004H.[2bE2,Wk]3s\u0007J,\u0017\r^5p]B{G.[2z)\t!w\rE\u0002OKfJ!AZ(\u0003\r=\u0003H/[8o\u0011\u0015a\u0001\u00021\u0001i!\tIG.D\u0001k\u0015\tYg&\u0001\u0003d_J,\u0017BA7k\u00059\tU\u000f\u001e5f]RL7-\u0019;j_:\fQEZ5oI\u0006\u0003\b\u000f\\5dC\ndW-V:fe\u001e\u0013x.\u001e9De\u0016\fG/[8o!>d\u0017nY=\u0015\u0005A\f\bc\u0001(f\u0005\")A\"\u0003a\u0001Q\"\u0012\u0001a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m\u000e\n!b\u001d;fe\u0016|G/\u001f9f\u0013\tAXOA\u0005D_6\u0004xN\\3oi\u0002")
public class AuthenticationSuccessEventListener
implements ApplicationListener<AuthenticationSuccessEvent> {
    private final List<UserProfileCreationPolicy> userProfileCreationPolicies;
    private final List<UserGroupMembershipCreationPolicy> userGroupMembershipCreationPolicies;
    private final Logger logger;

    public boolean supportsAsyncExecution() {
        return false;
    }

    private Logger logger() {
        return this.logger;
    }

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        Authentication authentication = event.getAuthentication();
        if (authentication != null && Strings.isNotEmpty((String)authentication.getName())) {
            block14: {
                block13: {
                    Authentication authFromContext = SecurityContextHolder.getContext().getAuthentication();
                    try {
                        Option<UserGroupMembershipCreationPolicy> ugCreationPolicy;
                        if (authFromContext == null) {
                            SecurityContextHolder.getContext().setAuthentication(authentication);
                        }
                        boolean hasLoginPermission = SecurityServiceLocator.getPermissionEnforcer().hasPermission(authentication, new Permission[]{PlatformPermissions.LOGIN});
                        if (authentication.getName().equals("_xl-deploy-config-admin_")) {
                            break block13;
                        }
                        if (!hasLoginPermission) {
                            this.logger().info("User [{}] do not have permission to login.Please contact your Deploy administrator for further assistance.", (Object)authentication.getName());
                            throw new DisabledException("You do not have permission to login.Please contact your Deploy administrator for further assistance.");
                        }
                        Option<UserProfileCreationPolicy> creationPolicyOption = this.findApplicableUserCreationPolicy(authentication);
                        Option<UserProfileCreationPolicy> option = creationPolicyOption;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            UserProfileCreationPolicy creationPolicy = (UserProfileCreationPolicy)some.value();
                            creationPolicy.createProfile(authentication);
                        } else if (None$.MODULE$.equals(option)) {
                            this.logger().info("No applicable user profile creation policy found for authentication: {}", (Object)authentication.getName());
                        } else {
                            throw new MatchError(option);
                        }
                        Option<UserGroupMembershipCreationPolicy> option2 = ugCreationPolicy = this.findApplicableUserGroupCreationPolicy(authentication);
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            UserGroupMembershipCreationPolicy policy = (UserGroupMembershipCreationPolicy)some.value();
                            policy.updateUserGroupMembership(authentication);
                            break block14;
                        }
                        if (None$.MODULE$.equals(option2)) {
                            this.logger().info("No applicable user group membership creation policy found for authentication: {}", (Object)authentication.getName());
                            break block14;
                        }
                        throw new MatchError(option2);
                    }
                    finally {
                        SecurityContextHolder.getContext().setAuthentication(authFromContext);
                    }
                }
                return;
            }
            return;
        }
    }

    private Option<UserProfileCreationPolicy> findApplicableUserCreationPolicy(Authentication authentication) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.userProfileCreationPolicies).asScala().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.order()), (Ordering)Ordering.Int$.MODULE$)).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.policyApplies(authentication)));
    }

    private Option<UserGroupMembershipCreationPolicy> findApplicableUserGroupCreationPolicy(Authentication authentication) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.userGroupMembershipCreationPolicies).asScala().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.order()), (Ordering)Ordering.Int$.MODULE$)).find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.policyApplies(authentication)));
    }

    public AuthenticationSuccessEventListener(List<UserProfileCreationPolicy> userProfileCreationPolicies, List<UserGroupMembershipCreationPolicy> userGroupMembershipCreationPolicies) {
        this.userProfileCreationPolicies = userProfileCreationPolicies;
        this.userGroupMembershipCreationPolicies = userGroupMembershipCreationPolicies;
        this.logger = LoggerFactory.getLogger(AuthenticationSuccessEventListener.class);
    }
}

