/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment.setter;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertySetter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPropertySetter.class);
    private RepositoryService repository;

    AbstractPropertySetter(RepositoryService repository) {
        this.repository = repository;
    }

    public abstract void setProperty(ConfigurationItem var1, ConfigurationItem var2, ConfigurationItem var3, ConfigurationItem var4, ConsolidatedDictionary var5, PropertyDescriptor var6, PropertyDescriptor var7);

    Object getValueIfExists(ConfigurationItem configurationItem, String name) {
        if (configurationItem == null || !configurationItem.hasProperty(name)) {
            return null;
        }
        return configurationItem.getProperty(name);
    }

    private boolean optionalKind(PropertyDescriptor deployablePropDesc, PropertyKind kind) {
        return deployablePropDesc == null || deployablePropDesc.getKind() == kind;
    }

    private Collection<ConfigurationItem> getCollectionOfCis(Object valueToSet) {
        ArrayList cis = Lists.newArrayList();
        for (String s : (Collection)valueToSet) {
            cis.add(this.repository.read(s));
        }
        return cis;
    }

    private Collection<String> splitValue(Object valueToSet) {
        Checks.checkArgument((valueToSet instanceof String || valueToSet instanceof StringValue ? 1 : 0) != 0, (String)"Should be String or StringValue to split.", (Object[])new Object[0]);
        Splitter splitter = Splitter.on((String)",").omitEmptyStrings();
        return Lists.newArrayList((Iterable)splitter.split((CharSequence)valueToSet.toString()));
    }

    Object convertIfNeeded(Object valueToSet, PropertyDescriptor deployablePropDesc, PropertyDescriptor deployedPropDesc) {
        if (valueToSet == null) {
            return null;
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.STRING) && deployedPropDesc.getKind() == PropertyKind.CI) {
            return this.repository.read(valueToSet.toString());
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.SET_OF_STRING) && deployedPropDesc.getKind() == PropertyKind.SET_OF_CI) {
            return Sets.newHashSet(this.getCollectionOfCis(valueToSet));
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.STRING) && deployedPropDesc.getKind() == PropertyKind.SET_OF_CI) {
            return Sets.newHashSet(this.getCollectionOfCis(this.splitValue(valueToSet)));
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.LIST_OF_STRING) && deployedPropDesc.getKind() == PropertyKind.LIST_OF_CI) {
            return Lists.newArrayList(this.getCollectionOfCis(valueToSet));
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.STRING) && deployedPropDesc.getKind() == PropertyKind.LIST_OF_CI) {
            return Lists.newArrayList(this.getCollectionOfCis(this.splitValue(valueToSet)));
        }
        if (deployedPropDesc.getKind() == PropertyKind.STRING) {
            if (valueToSet instanceof EncryptedStringValue && !deployedPropDesc.isPassword()) {
                logger.warn("Going to write a Encrypted value as plaintext in \"{}\", as it is not a password field.", (Object)deployedPropDesc);
            }
            return valueToSet.toString();
        }
        if (valueToSet instanceof StringValue) {
            return valueToSet.toString();
        }
        return valueToSet;
    }

    boolean isNullOrEmpty(Object value, PropertyDescriptor pd) {
        if (value == null) {
            return true;
        }
        switch (pd.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case STRING: 
            case ENUM: 
            case DATE: 
            case CI: {
                return Strings.isNullOrEmpty((String)value.toString());
            }
            case SET_OF_STRING: 
            case SET_OF_CI: 
            case LIST_OF_STRING: 
            case LIST_OF_CI: {
                return ((Collection)value).isEmpty();
            }
            case MAP_STRING_STRING: {
                return ((Map)value).isEmpty();
            }
        }
        throw new IllegalStateException("Unsupported property kind: " + String.valueOf(pd.getKind()) + " for property: " + pd.getFqn());
    }

    void setDeployedFromDictionary(ConfigurationItem deployed, ConsolidatedDictionary dictionary, PropertyDescriptor deployedPropDesc, PropertyDescriptor deployablePropDesc) {
        if (dictionary.containsKey(deployedPropDesc.getFqn())) {
            Object value = dictionary.get(deployedPropDesc.getFqn());
            value = this.convertIfNeeded(value, deployablePropDesc, deployedPropDesc);
            deployedPropDesc.set(deployed, value);
        }
    }

    void setSilently(ConfigurationItem ci, PropertyDescriptor pd, Object value) {
        try {
            pd.set(ci, value);
        }
        catch (RuntimeException exc) {
            logger.error("Could not convert (resolved) value to correct type for property {} of {}. Error message was: {}", new Object[]{pd, ci, exc.getMessage()});
            ci.get$validationMessages().add(ValidationMessage.warn((String)ci.getId(), (String)pd.getName(), (String)"Could not correctly convert resolved value, property empty"));
        }
    }
}

