/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaQueryFactory;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.NamedQuery;
import org.springframework.data.jpa.repository.query.PartTreeJpaQuery;
import org.springframework.data.jpa.repository.query.QueryRewriterProvider;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class JpaQueryLookupStrategy {
    private static final Log LOG = LogFactory.getLog(JpaQueryLookupStrategy.class);
    private static final RepositoryQuery NO_QUERY = new NoQuery();

    private JpaQueryLookupStrategy() {
    }

    @Deprecated(since="3.4")
    public static QueryLookupStrategy create(EntityManager em, JpaQueryMethodFactory queryMethodFactory, @Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider, QueryRewriterProvider queryRewriterProvider, EscapeCharacter escape) {
        return JpaQueryLookupStrategy.create(em, queryMethodFactory, key, new ValueExpressionDelegate(new QueryMethodValueEvaluationContextAccessor((Environment)new StandardEnvironment(), evaluationContextProvider.getEvaluationContextProvider()), (ValueExpressionParser)ValueExpressionDelegate.create()), queryRewriterProvider, escape);
    }

    public static QueryLookupStrategy create(EntityManager em, JpaQueryMethodFactory queryMethodFactory, @Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate delegate, QueryRewriterProvider queryRewriterProvider, EscapeCharacter escape) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null");
        Assert.notNull((Object)delegate, (String)"ValueExpressionDelegate must not be null");
        return switch (key != null ? key : QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND) {
            case QueryLookupStrategy.Key.CREATE -> new CreateQueryLookupStrategy(em, queryMethodFactory, queryRewriterProvider, escape);
            case QueryLookupStrategy.Key.USE_DECLARED_QUERY -> new DeclaredQueryLookupStrategy(em, queryMethodFactory, delegate, queryRewriterProvider);
            case QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND -> new CreateIfNotFoundQueryLookupStrategy(em, queryMethodFactory, new CreateQueryLookupStrategy(em, queryMethodFactory, queryRewriterProvider, escape), new DeclaredQueryLookupStrategy(em, queryMethodFactory, delegate, queryRewriterProvider), queryRewriterProvider);
            default -> throw new IllegalArgumentException(String.format("Unsupported query lookup strategy %s", key));
        };
    }

    private static abstract class AbstractQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EntityManager em;
        private final JpaQueryMethodFactory queryMethodFactory;
        private final QueryRewriterProvider queryRewriterProvider;

        public AbstractQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, QueryRewriterProvider queryRewriterProvider) {
            Assert.notNull((Object)em, (String)"EntityManager must not be null");
            Assert.notNull((Object)queryMethodFactory, (String)"JpaQueryMethodFactory must not be null");
            this.em = em;
            this.queryMethodFactory = queryMethodFactory;
            this.queryRewriterProvider = queryRewriterProvider;
        }

        public final RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            JpaQueryMethod queryMethod = this.queryMethodFactory.build(method, metadata, factory);
            return this.resolveQuery(queryMethod, this.queryRewriterProvider.getQueryRewriter(queryMethod), this.em, namedQueries);
        }

        protected abstract RepositoryQuery resolveQuery(JpaQueryMethod var1, QueryRewriter var2, EntityManager var3, NamedQueries var4);
    }

    private static class CreateIfNotFoundQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final DeclaredQueryLookupStrategy lookupStrategy;
        private final CreateQueryLookupStrategy createStrategy;

        public CreateIfNotFoundQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, CreateQueryLookupStrategy createStrategy, DeclaredQueryLookupStrategy lookupStrategy, QueryRewriterProvider queryRewriterProvider) {
            super(em, queryMethodFactory, queryRewriterProvider);
            Assert.notNull((Object)createStrategy, (String)"CreateQueryLookupStrategy must not be null");
            Assert.notNull((Object)lookupStrategy, (String)"DeclaredQueryLookupStrategy must not be null");
            this.createStrategy = createStrategy;
            this.lookupStrategy = lookupStrategy;
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, QueryRewriter queryRewriter, EntityManager em, NamedQueries namedQueries) {
            RepositoryQuery lookupQuery = this.lookupStrategy.resolveQuery(method, queryRewriter, em, namedQueries);
            if (lookupQuery != NO_QUERY) {
                return lookupQuery;
            }
            return this.createStrategy.resolveQuery(method, queryRewriter, em, namedQueries);
        }
    }

    private static class CreateQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final EscapeCharacter escape;

        public CreateQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, QueryRewriterProvider queryRewriterProvider, EscapeCharacter escape) {
            super(em, queryMethodFactory, queryRewriterProvider);
            this.escape = escape;
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, QueryRewriter queryRewriter, EntityManager em, NamedQueries namedQueries) {
            return new PartTreeJpaQuery(method, em, this.escape);
        }
    }

    private static class DeclaredQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final ValueExpressionDelegate valueExpressionDelegate;

        public DeclaredQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, ValueExpressionDelegate delegate, QueryRewriterProvider queryRewriterProvider) {
            super(em, queryMethodFactory, queryRewriterProvider);
            this.valueExpressionDelegate = delegate;
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, QueryRewriter queryRewriter, EntityManager em, NamedQueries namedQueries) {
            if (method.isProcedureQuery()) {
                return JpaQueryFactory.INSTANCE.fromProcedureAnnotation(method, em);
            }
            if (StringUtils.hasText((String)method.getAnnotatedQuery())) {
                if (method.hasAnnotatedQueryName()) {
                    LOG.warn((Object)String.format("Query method %s is annotated with both, a query and a query name; Using the declared query", new Object[]{method}));
                }
                return JpaQueryFactory.INSTANCE.fromMethodWithQueryString(method, em, method.getRequiredAnnotatedQuery(), this.getCountQuery(method, namedQueries, em), queryRewriter, this.valueExpressionDelegate);
            }
            String name = method.getNamedQueryName();
            if (namedQueries.hasQuery(name)) {
                return JpaQueryFactory.INSTANCE.fromMethodWithQueryString(method, em, namedQueries.getQuery(name), this.getCountQuery(method, namedQueries, em), queryRewriter, this.valueExpressionDelegate);
            }
            RepositoryQuery query = NamedQuery.lookupFrom(method, em);
            return query != null ? query : NO_QUERY;
        }

        @Nullable
        private String getCountQuery(JpaQueryMethod method, NamedQueries namedQueries, EntityManager em) {
            if (StringUtils.hasText((String)method.getCountQuery())) {
                return method.getCountQuery();
            }
            String queryName = method.getNamedCountQueryName();
            if (!StringUtils.hasText((String)queryName)) {
                return method.getCountQuery();
            }
            if (namedQueries.hasQuery(queryName)) {
                return namedQueries.getQuery(queryName);
            }
            boolean namedQuery = NamedQuery.hasNamedQuery(em, queryName);
            if (namedQuery) {
                return method.getQueryExtractor().extractQueryString(em.createNamedQuery(queryName));
            }
            return null;
        }
    }

    static class NoQuery
    implements RepositoryQuery {
        NoQuery() {
        }

        public Object execute(Object[] parameters) {
            throw new IllegalStateException("NoQuery should not be executed!");
        }

        public QueryMethod getQueryMethod() {
            throw new IllegalStateException("NoQuery does not have a QueryMethod!");
        }
    }
}

