/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.se;

import java.security.AccessController;
import org.jboss.resteasy.core.se.ResteasySeInstance;

final class SecurityActions {
    private SecurityActions() {
    }

    static void addShutdownHook(Thread shutdownHook) {
        if (System.getSecurityManager() == null) {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        } else {
            AccessController.doPrivileged(() -> {
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                return null;
            });
        }
    }

    static ClassLoader resolveClassLoader(Class<?> c) {
        if (c == null) {
            return SecurityActions.currentClassLoader();
        }
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(c::getClassLoader);
    }

    private static ClassLoader currentClassLoader() {
        if (System.getSecurityManager() == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ResteasySeInstance.class.getClassLoader();
            }
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return cl;
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ResteasySeInstance.class.getClassLoader();
            }
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return cl;
        });
    }
}

